/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.geo.mapviewer2;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jxmapviewer.viewer.TileFactoryInfo;

public final class TileTester {
    public static void testTileLoading(TileFactoryInfo info) throws TileTesterException {
        TileTester.isReachable(info.getTileUrl(0, 0, 0));
        TileTester.isReachable(info.getTileUrl(0, 0, info.getMaximumZoomLevel() - info.getMinimumZoomLevel()));
    }

    private static void isReachable(String url) throws TileTesterException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", "PalladianTileTester/1.0 (+https://palladian.ws)");
            int status = conn.getResponseCode();
            if (status < 200 || status > 300) {
                throw new TileTesterException(String.format("HTTP status %d for URL %s", status, url));
            }
            String contentType = conn.getHeaderField("Content-Type");
            if (contentType == null || !contentType.startsWith("image/")) {
                throw new TileTesterException(String.format("Invalid content type %s for URL %s", contentType, url));
            }
        }
        catch (IOException iOException) {
            throw new TileTesterException(String.format("Failed loading URL %s", url));
        }
    }

    private TileTester() {
    }

    public static final class TileTesterException
    extends Exception {
        TileTesterException(String message) {
            super(message);
        }
    }
}

