/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jface.preference.IPreferenceStore;

public class ApacheConfigurationAdapter
implements Configuration {
    private final IPreferenceStore prefStore;

    public ApacheConfigurationAdapter(IPreferenceStore prefStore) {
        if (prefStore == null) {
            throw new IllegalArgumentException("Parameter must not be null.");
        }
        this.prefStore = prefStore;
    }

    public Configuration subset(String prefix) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(String key) {
        return this.prefStore.contains(key);
    }

    public void addProperty(String key, Object value) {
        if (this.containsKey(key)) {
            throw new UnsupportedOperationException("Property \"" + key + "\" already exists; IPreferenceStore does not allow multiple values.");
        }
        this.setProperty(key, value);
    }

    public void setProperty(String key, Object value) {
        if (value instanceof Boolean) {
            this.prefStore.setValue(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            this.prefStore.setValue(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.prefStore.setValue(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.prefStore.setValue(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.prefStore.setValue(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            this.prefStore.setValue(key, (String)value);
        } else {
            throw new IllegalArgumentException("Type \"" + value.getClass().getName() + "\" is not supported.");
        }
    }

    public void clearProperty(String key) {
        this.prefStore.setToDefault(key);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String key) {
        throw new UnsupportedOperationException();
    }

    public Iterator<String> getKeys(String prefix) {
        throw new UnsupportedOperationException();
    }

    public Iterator<String> getKeys() {
        throw new UnsupportedOperationException();
    }

    public Properties getProperties(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String key) {
        return this.prefStore.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, (Boolean)defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        if (!value.booleanValue()) {
            value = defaultValue;
        }
        return value;
    }

    public byte getByte(String key) {
        throw new UnsupportedOperationException();
    }

    public byte getByte(String key, byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Byte getByte(String key, Byte defaultValue) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String key) {
        return this.prefStore.getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, (Double)defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        Double value = this.getDouble(key);
        if (value == 0.0) {
            value = defaultValue;
        }
        return value;
    }

    public float getFloat(String key) {
        return this.prefStore.getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, Float.valueOf(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Float value = Float.valueOf(this.getFloat(key));
        if (value.floatValue() == 0.0f) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        return this.prefStore.getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInteger(key, defaultValue);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer value = this.getInt(key);
        if (value == 0) {
            value = defaultValue;
        }
        return value;
    }

    public long getLong(String key) {
        return this.prefStore.getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, (Long)defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        Long value = this.getLong(key);
        if (value == 0L) {
            value = defaultValue;
        }
        return value;
    }

    public short getShort(String key) {
        throw new UnsupportedOperationException();
    }

    public short getShort(String key, short defaultValue) {
        throw new UnsupportedOperationException();
    }

    public Short getShort(String key, Short defaultValue) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String key) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getBigInteger(String key) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        throw new UnsupportedOperationException();
    }

    public String getString(String key) {
        return this.prefStore.getString(key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value.equals("")) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStringArray(String key) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getList(String key) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getList(String key, List<?> defaultValue) {
        throw new UnsupportedOperationException();
    }
}

