/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButtonGroup;
import org.knime.core.node.defaultnodesettings.DialogComponentFileChooser;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.helper.DatasetReaderNodeModel;

public class DatasetReaderNodeDialog
extends DefaultNodeSettingsPane {
    private static final String INDEX_FILE_CHOOSER_HISTORY_ID = "ws.palladian.nodes.helper.DatasetReader.indexFile";
    private static final String INDEX_DIRECTORY_HISTORY_ID = "ws.palladian.nodes.helper.DatasetReader.directory";
    private final SettingsModelString settingSourceType = DatasetReaderNodeDialog.createSettingsModelSourceType();
    private final SettingsModelString settingIndexFile = DatasetReaderNodeDialog.createSettingsModelIndexFile();
    private final SettingsModelString settingDirectorySource = DatasetReaderNodeDialog.createSettingsModelDirectory();
    private final SettingsModelString settingSeparator = DatasetReaderNodeDialog.createSettingsModelSeparationString();

    protected DatasetReaderNodeDialog() {
        this.settingSourceType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DatasetReaderNodeDialog.this.enableItems();
            }
        });
        this.addDialogComponent((DialogComponent)new DialogComponentButtonGroup(this.settingSourceType, false, "Source type", DatasetReaderNodeModel.SOURCE_TYPES));
        this.addDialogComponent((DialogComponent)new DialogComponentFileChooser(this.settingIndexFile, INDEX_FILE_CHOOSER_HISTORY_ID, new String[]{".txt", ".tsv", ".csv"}));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settingSeparator, "Separation string"));
        this.addDialogComponent((DialogComponent)new DialogComponentFileChooser(this.settingDirectorySource, INDEX_DIRECTORY_HISTORY_ID, 0, true));
        this.enableItems();
    }

    static SettingsModelString createSettingsModelSourceType() {
        return new SettingsModelString("sourceType", "Index file");
    }

    static SettingsModelString createSettingsModelIndexFile() {
        return new SettingsModelString("datasetIndexFile", null);
    }

    static SettingsModelString createSettingsModelDirectory() {
        return new SettingsModelString("datasetDirectory", null);
    }

    static SettingsModelString createSettingsModelSeparationString() {
        return new SettingsModelString("datasetSeparationString", " ");
    }

    private void enableItems() {
        String selectedValue = this.settingSourceType.getStringValue();
        this.settingIndexFile.setEnabled(selectedValue.equals("Index file"));
        this.settingSeparator.setEnabled(selectedValue.equals("Index file"));
        this.settingDirectorySource.setEnabled(selectedValue.equals("Directory structure"));
    }
}

