/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.helper.io.FileHelper;
import ws.palladian.helper.io.LineAction;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.DatasetReaderNodeDialog;

public class DatasetReaderNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(DatasetReaderNodeModel.class);
    static final String CFGKEY_INDEX_FILE = "datasetIndexFile";
    static final String CFGKEY_SEPARATION_STRING = "datasetSeparationString";
    static final String DEFAULT_SEPARATION_STRING = " ";
    static final String CFGKEY_SOURCE_DIRECTORY = "datasetDirectory";
    static final String CFGKEY_SOURCE_TYPE = "sourceType";
    static final String SOURCE_TYPE_FILE = "Index file";
    static final String SOURCE_TYPE_DIRECTORY = "Directory structure";
    static final String[] SOURCE_TYPES = new String[]{"Index file", "Directory structure"};
    static final String DEFAULT_SOURCE_TYPE = "Index file";
    private final SettingsModelString settingIndexFile = DatasetReaderNodeDialog.createSettingsModelIndexFile();
    private final SettingsModelString settingSeparator = DatasetReaderNodeDialog.createSettingsModelSeparationString();
    private final SettingsModelString settingDirectorySource = DatasetReaderNodeDialog.createSettingsModelDirectory();
    private final SettingsModelString settingSourceType = DatasetReaderNodeDialog.createSettingsModelSourceType();

    protected DatasetReaderNodeModel() {
        super(0, 1);
        this.enableItems();
        this.settingSourceType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DatasetReaderNodeModel.this.enableItems();
            }
        });
    }

    private void enableItems() {
        String selectedValue = this.settingSourceType.getStringValue();
        this.settingIndexFile.setEnabled(selectedValue.equals("Index file"));
        this.settingSeparator.setEnabled(selectedValue.equals("Index file"));
        this.settingDirectorySource.setEnabled(selectedValue.equals(SOURCE_TYPE_DIRECTORY));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        DataTableSpec outputSpec = this.createOutputSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        String sourceType = this.settingSourceType.getStringValue();
        if ("Index file".equals(sourceType)) {
            this.readFromIndexFile(exec, container);
        } else {
            this.readFromDirectory(exec, container);
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    private void readFromIndexFile(final ExecutionContext exec, final BufferedDataContainer container) {
        String indexFile = this.settingIndexFile.getStringValue();
        final String separationString = this.settingSeparator.getStringValue();
        final String datasetPath = new File(indexFile).getParent();
        final int totalLines = FileHelper.getNumberOfLines((String)indexFile);
        FileHelper.performActionOnEveryLine((String)indexFile, (LineAction)new LineAction(){

            public void performAction(String line, int lineNumber) {
                String fileContent;
                RowKey key = RowKey.createRowKey((int)lineNumber);
                String[] split = line.split(separationString);
                if (split.length != 2) {
                    logger.warn((Object)("Could not read line " + lineNumber + " : \"" + line + "\""));
                    return;
                }
                DataCell[] cells = new DataCell[2];
                String fileName = datasetPath + File.separator + split[0];
                try {
                    fileContent = FileHelper.readFileToString((String)fileName);
                }
                catch (IOException e) {
                    logger.warn((Object)("File \"" + fileName + "\" does not exist or cannot be accessed"), (Throwable)e);
                    return;
                }
                cells[0] = new StringCell(fileContent);
                cells[1] = new StringCell(split[1]);
                DefaultRow row = new DefaultRow(key, cells);
                container.addRowToTable((DataRow)row);
                try {
                    exec.checkCanceled();
                }
                catch (CanceledExecutionException e) {
                    logger.debug((Object)"Execution canceled, breaking line loop", (Throwable)e);
                    this.breakLineLoop();
                }
                exec.setProgress((double)lineNumber / (double)totalLines, "Adding row " + lineNumber);
            }
        });
    }

    private void readFromDirectory(ExecutionContext exec, BufferedDataContainer container) {
        String directoryPath = this.settingDirectorySource.getStringValue();
        File datasetDirectory = new File(directoryPath);
        if (!datasetDirectory.isDirectory()) {
            throw new IllegalStateException("\"" + directoryPath + "\" is not a directory");
        }
        long rowCount = 0L;
        File[] fileArray = datasetDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                File[] filesInClass;
                File[] fileArray2 = filesInClass = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".txt");
                    }
                });
                int n3 = filesInClass.length;
                int n4 = 0;
                while (n4 < n3) {
                    File document = fileArray2[n4];
                    RowKey key = RowKey.createRowKey((long)rowCount++);
                    DataCell[] cells = new DataCell[2];
                    try {
                        cells[0] = new StringCell(FileHelper.readFileToString((File)document));
                    }
                    catch (IOException e) {
                        logger.warn((Object)("File \"" + String.valueOf(document) + "\" does not exist or cannot be accessed"), (Throwable)e);
                    }
                    cells[1] = new StringCell(document.getParentFile().getName());
                    DefaultRow row = new DefaultRow(key, cells);
                    container.addRowToTable((DataRow)row);
                    try {
                        exec.checkCanceled();
                    }
                    catch (CanceledExecutionException canceledExecutionException) {
                        break;
                    }
                    exec.setProgress("Adding row " + rowCount);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private DataTableSpec createOutputSpec() {
        DataColumnSpec[] allColSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("content", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("categories", StringCell.TYPE).createSpec()};
        DataTableSpec outputSpec = new DataTableSpec(allColSpecs);
        return outputSpec;
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String sourceType = this.settingSourceType.getStringValue();
        if (sourceType == null) {
            throw new InvalidSettingsException("no source type specified, please configure the node first.");
        }
        if (SOURCE_TYPE_DIRECTORY.equals(sourceType)) {
            String sourceDirectory = this.settingDirectorySource.getStringValue();
            if (sourceDirectory == null) {
                throw new InvalidSettingsException("no source directory specified, please configure the node first.");
            }
            File sourceDirectoryFile = new File(sourceDirectory);
            if (!sourceDirectoryFile.exists() || !sourceDirectoryFile.isDirectory()) {
                throw new InvalidSettingsException("specified source directory \"" + sourceDirectory + "\" does not exist or is no directory.");
            }
        } else if ("Index file".equals(sourceType)) {
            String indexFile = this.settingIndexFile.getStringValue();
            if (indexFile == null) {
                throw new InvalidSettingsException("no index file specified, please configure the node first.");
            }
            if (!FileHelper.fileExists((String)indexFile)) {
                throw new InvalidSettingsException("file \"" + indexFile + "\" does not exist.");
            }
        } else {
            throw new InvalidSettingsException("Invalid source type \"" + sourceType + "\"");
        }
        return new DataTableSpec[]{this.createOutputSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingIndexFile.saveSettingsTo(settings);
        this.settingSeparator.saveSettingsTo(settings);
        this.settingDirectorySource.saveSettingsTo(settings);
        this.settingSourceType.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingIndexFile.loadSettingsFrom(settings);
        this.settingSeparator.loadSettingsFrom(settings);
        this.settingDirectorySource.loadSettingsFrom(settings);
        this.settingSourceType.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingIndexFile.validateSettings(settings);
        this.settingSeparator.validateSettings(settings);
        this.settingDirectorySource.validateSettings(settings);
        this.settingSourceType.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

