/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.date.DateAndTimeCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.util.FileUtil;

public final class PalladianKnimeHelper {
    private static final NodeLogger logger = NodeLogger.getLogger(PalladianKnimeHelper.class);

    private PalladianKnimeHelper() {
    }

    @Deprecated
    public static DateAndTimeCell getDateAndTimeCell(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new DateAndTimeCell(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static DataCell createDateAndTime(Date date) {
        return date != null ? PalladianKnimeHelper.getDateAndTimeCell(date) : DataType.getMissingCell();
    }

    @SafeVarargs
    public static DataColumnSpec guessColumn(DataTableSpec tableSpec, Class<? extends DataValue> ... valueClasses) throws InvalidSettingsException {
        return PalladianKnimeHelper.guessColumn(tableSpec, 0, valueClasses);
    }

    @SafeVarargs
    public static DataColumnSpec guessColumn(DataTableSpec tableSpec, int startIndex, Class<? extends DataValue> ... valueClasses) throws InvalidSettingsException {
        return PalladianKnimeHelper.guessColumn(tableSpec, startIndex, false, valueClasses);
    }

    @SafeVarargs
    public static DataColumnSpec guessColumn(DataTableSpec tableSpec, int startIndex, boolean reverse, Class<? extends DataValue> ... valueClasses) throws InvalidSettingsException {
        Class<? extends DataValue> valueClass;
        Objects.requireNonNull(tableSpec, "tableSpec was null.");
        Objects.requireNonNull(valueClasses, "valueClasses was null.");
        if (valueClasses.length == 0) {
            throw new IllegalArgumentException("valueClasses was empty.");
        }
        Class<? extends DataValue>[] classArray = valueClasses;
        int n = valueClasses.length;
        int n2 = 0;
        while (n2 < n) {
            valueClass = classArray[n2];
            if (DataCell.class.isAssignableFrom(valueClass)) {
                throw new IllegalArgumentException(String.valueOf(valueClass) + " is a DataCell; only DataValues should be used.");
            }
            ++n2;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex must be greater/equal zero.");
        }
        if (startIndex != 0 && startIndex >= tableSpec.getNumColumns()) {
            throw new IllegalArgumentException("startIndex must not be greater/equal than the number of columns as specified in the tableSpec.");
        }
        classArray = valueClasses;
        n = valueClasses.length;
        n2 = 0;
        while (n2 < n) {
            valueClass = classArray[n2];
            int start = reverse ? tableSpec.getNumColumns() - 1 : startIndex;
            int end = reverse ? startIndex - 1 : tableSpec.getNumColumns();
            int inc = reverse ? -1 : 1;
            int i = start;
            while (i != end) {
                DataColumnSpec columnSpec = tableSpec.getColumnSpec(i);
                if (columnSpec.getType().isCompatible(valueClass)) {
                    return columnSpec;
                }
                i += inc;
            }
            ++n2;
        }
        throw new InvalidSettingsException("No suitable column for " + PalladianKnimeHelper.listValueNames(valueClasses) + " found");
    }

    public static DataColumnSpec guessColumnByName(DataTableSpec tableSpec, Class<? extends DataValue> valueClass, String ... names) throws InvalidSettingsException {
        for (DataColumnSpec columnSpec : tableSpec) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (columnSpec.getName().equalsIgnoreCase(name) && columnSpec.getType().isCompatible(valueClass)) {
                    return columnSpec;
                }
                ++n2;
            }
        }
        throw new InvalidSettingsException("No suitable column with any of the name(s) " + String.join((CharSequence)",", names) + " found");
    }

    @SafeVarargs
    @Deprecated
    public static DataColumnSpec getColumn(DataTableSpec tableSpec, String desiredColumnName, Class<? extends DataValue> ... valueClasses) throws InvalidSettingsException {
        Objects.requireNonNull(tableSpec, "tableSpec was null.");
        Objects.requireNonNull(valueClasses, "valueClasses was null.");
        if (valueClasses.length == 0) {
            throw new IllegalArgumentException("valueClasses was empty.");
        }
        DataColumnSpec columnSpec = tableSpec.getColumnSpec(desiredColumnName);
        if (columnSpec == null) {
            return null;
        }
        Class<? extends DataValue>[] classArray = valueClasses;
        int n = valueClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends DataValue> valueClass = classArray[n2];
            if (columnSpec.getType().isCompatible(valueClass)) {
                return columnSpec;
            }
            ++n2;
        }
        throw new InvalidSettingsException("Input column \"" + desiredColumnName + "\" is not compatible to " + PalladianKnimeHelper.listValueNames(valueClasses));
    }

    @SafeVarargs
    public static DataColumnSpec checkHasColumn(DataTableSpec tableSpec, String desiredColumnName, Class<? extends DataValue> ... valueClasses) throws InvalidSettingsException {
        DataColumnSpec spec = PalladianKnimeHelper.getColumn(tableSpec, desiredColumnName, valueClasses);
        if (spec == null) {
            throw new InvalidSettingsException("Expected table to have a column \"" + desiredColumnName + "\" compatible to " + PalladianKnimeHelper.listValueNames(valueClasses));
        }
        return spec;
    }

    @Deprecated
    public static void tryLoadValidatedSettings(NodeSettingsRO settings, SettingsModel model, String cfgKey) {
        try {
            model.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            logger.debug((Object)("Ignoring setting '" + cfgKey + "' for backwards compatibility."));
        }
    }

    public static void tryLoadValidatedSettings(NodeSettingsRO settings, SettingsModel model) {
        try {
            model.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            logger.debug((Object)("Ignoring " + model.toString() + " for backwards compatibility."));
        }
    }

    public static void tryValidateSettings(NodeSettingsRO settings, SettingsModel model, String cfgKey) {
        try {
            model.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            logger.debug((Object)("Ignoring setting '" + cfgKey + "' for backwards compatibility."));
        }
    }

    public static void tryValidateSettings(NodeSettingsRO settings, SettingsModel model) {
        try {
            model.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            logger.debug((Object)("Ignoring " + model.toString() + " for backwards compatibility."));
        }
    }

    public static boolean anyMissing(DataCell ... cells) {
        DataCell[] dataCellArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            DataCell cell = dataCellArray[n2];
            if (cell.isMissing()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getString(DataCell cell) {
        if (cell.isMissing()) {
            return null;
        }
        if (cell instanceof StringValue) {
            return ((StringValue)cell).getStringValue();
        }
        return null;
    }

    public static DataCell createStringCell(String stringOrNull) {
        return stringOrNull != null ? new StringCell(stringOrNull) : DataType.getMissingCell();
    }

    public static DataCell createIntCell(Integer intOrNull) {
        return intOrNull != null ? new IntCell(intOrNull.intValue()) : DataType.getMissingCell();
    }

    public static DataCell createDoubleCell(Double doubleOrNull) {
        return doubleOrNull != null ? new DoubleCell(doubleOrNull.doubleValue()) : DataType.getMissingCell();
    }

    public static DataCell createLongCell(Long longOrNull) {
        return longOrNull != null ? new LongCell(longOrNull.longValue()) : DataType.getMissingCell();
    }

    @SafeVarargs
    private static String listValueNames(Class<? extends DataValue> ... valueClasses) {
        return String.join((CharSequence)", ", Arrays.stream(valueClasses).map(Class::getName).collect(Collectors.toList()));
    }

    public static int[] findColumnIndices(DataTableSpec spec, String ... columnNames) {
        int[] indices = new int[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            indices[i] = spec.findColumnIndex(columnNames[i]);
            ++i;
        }
        return indices;
    }

    public static File getFileFromUrlOrPath(String urlOrPath) {
        if (urlOrPath.startsWith("knime:")) {
            File file;
            try {
                file = FileUtil.getFileFromURL((URL)new URL(urlOrPath));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Invalid URL: " + urlOrPath);
            }
            if (file == null) {
                throw new IllegalArgumentException("Could not resolve URL: " + urlOrPath);
            }
            return file;
        }
        return new File(urlOrPath);
    }
}

