/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.base64.encoder2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.apache.tika.Tika;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.DataValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.util.FileUtil;
import org.knime.filehandling.core.connections.FSLocationSpec;
import org.knime.filehandling.core.connections.location.FSPathProvider;
import org.knime.filehandling.core.connections.location.FSPathProviderFactory;
import org.knime.filehandling.core.connections.uriexport.noconfig.NoConfigURIExporterFactory;
import org.knime.filehandling.core.data.location.FSLocationValue;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.base64.encoder2.Base64NodeSettings2;

class Base64Encoder2NodeModel
extends SimpleStreamableFunctionNodeModel {
    static final Class<? extends DataValue>[] INPUT_TYPES = new Class[]{BinaryObjectDataValue.class, StringValue.class, FSLocationValue.class};
    private final Base64NodeSettings2 nodeSettings = new Base64NodeSettings2();

    Base64Encoder2NodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        DataColumnSpec[] specs;
        String inputColumnName = this.nodeSettings.getSettingInputColumn().getStringValue();
        final int inputColumnIdx = spec.findColumnIndex(inputColumnName);
        boolean setName = StringUtils.notNullOrEmpty(this.nodeSettings.getSettingOutputColumn().getStringValue());
        String outputColumnName = setName ? this.nodeSettings.getSettingOutputColumn().getStringValue() : inputColumnName;
        final boolean additionalColumns = this.nodeSettings.getSettingAdditionalColumns().getBooleanValue();
        if (additionalColumns) {
            specs = new DataColumnSpec[]{new DataColumnSpecCreator(outputColumnName + " (encoded)", StringCell.TYPE).createSpec(), new DataColumnSpecCreator(outputColumnName + " (MIME type)", StringCell.TYPE).createSpec(), new DataColumnSpecCreator(outputColumnName + " (data: URL)", StringCell.TYPE).createSpec()};
        } else {
            Object name = setName ? outputColumnName : outputColumnName + " (encoded)";
            specs = new DataColumnSpec[]{new DataColumnSpecCreator((String)name, StringCell.TYPE).createSpec()};
        }
        AbstractCellFactory factory = new AbstractCellFactory(true, specs){

            public DataCell[] getCells(DataRow row) {
                DataCell inputCell = row.getCell(inputColumnIdx);
                Object[] outCells = new DataCell[specs.length];
                Arrays.fill(outCells, DataType.getMissingCell());
                if (!inputCell.isMissing()) {
                    if (inputCell.getType().isCompatible(BinaryObjectDataValue.class)) {
                        BinaryObjectDataValue binaryObject = (BinaryObjectDataValue)inputCell;
                        outCells = Base64Encoder2NodeModel.encodeToCells(() -> binaryObject.openInputStream(), additionalColumns);
                    } else if (inputCell.getType().isCompatible(FSLocationValue.class)) {
                        FSLocationValue fsLocationValue = (FSLocationValue)inputCell;
                        try {
                            Throwable throwable = null;
                            Object var6_10 = null;
                            try (FSPathProviderFactory ppFactory = FSPathProviderFactory.newFactory(Optional.empty(), (FSLocationSpec)fsLocationValue.getFSLocation());){
                                Throwable throwable2 = null;
                                Object var9_15 = null;
                                try (FSPathProvider pathProvider = ppFactory.create(fsLocationValue.getFSLocation());){
                                    NoConfigURIExporterFactory uriExporterFactory = pathProvider.getFSConnection().getDefaultURIExporterFactory();
                                    URI uri = uriExporterFactory.getExporter().toUri(pathProvider.getPath());
                                    File file = FileUtil.getFileFromURL((URL)uri.toURL());
                                    outCells = Base64Encoder2NodeModel.encodeToCells(() -> new FileInputStream(file), additionalColumns);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException | URISyntaxException exception) {}
                    } else if (inputCell.getType().isCompatible(StringValue.class)) {
                        StringValue stringValue = (StringValue)inputCell;
                        byte[] bytes = stringValue.getStringValue().getBytes();
                        outCells = Base64Encoder2NodeModel.encodeToCells(() -> new ByteArrayInputStream(bytes), additionalColumns);
                    }
                }
                return outCells;
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(spec);
        columnRearranger.append((CellFactory)factory);
        if (this.nodeSettings.getSettingRemoveInputColumn().getBooleanValue()) {
            columnRearranger.remove(new int[]{inputColumnIdx});
        }
        return columnRearranger;
    }

    private static DataCell[] encodeToCells(InputStreamSupplier inputStreamSupplier, boolean additionalCols) {
        DataCell[] cells;
        block21: {
            cells = new DataCell[additionalCols ? 3 : 1];
            try {
                String mimeType;
                String base64;
                Throwable throwable = null;
                Throwable throwable2 = null;
                try (InputStream inputStream = inputStreamSupplier.get();){
                    base64 = Base64Encoder2NodeModel.encodeBase64(inputStream);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                cells[0] = new StringCell(base64);
                if (!additionalCols) break block21;
                throwable2 = null;
                Object var6_8 = null;
                try (InputStream inputStream = inputStreamSupplier.get();){
                    mimeType = Base64Encoder2NodeModel.detectMimeType(inputStream);
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                cells[1] = new StringCell(mimeType);
                cells[2] = new StringCell(String.format("data:%s;base64,%s", mimeType, base64));
            }
            catch (IOException iOException) {}
        }
        return cells;
    }

    private static String encodeBase64(InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            int nRead;
            byte[] buffer = new byte[1024];
            while ((nRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                stream.write(buffer, 0, nRead);
            }
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(stream.toByteArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String detectMimeType(InputStream stream) throws IOException {
        return new Tika().detect(stream);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getSettingInputColumn().getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getSettingInputColumn().getStringValue(), INPUT_TYPES);
        } else {
            DataColumnSpec columnSpec = PalladianKnimeHelper.guessColumn(inSpec, INPUT_TYPES);
            this.setWarningMessage("Guessed input column: " + columnSpec.getName());
            this.nodeSettings.getSettingInputColumn().setStringValue(columnSpec.getName());
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    @FunctionalInterface
    private static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

