/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.decryptPassword;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class DecryptPasswordFromWorkflowNodeSettings
implements NodeSettings {
    final SettingsModelString workflowFileModel = new SettingsModelString("workflow", null);
    final SettingsModelString encryptionKeyModel = new SettingsModelString("encryptionKey", null);

    DecryptPasswordFromWorkflowNodeSettings() {
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        this.workflowFileModel.saveSettingsTo(settings);
        this.encryptionKeyModel.saveSettingsTo(settings);
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.workflowFileModel.loadSettingsFrom(settings);
        this.encryptionKeyModel.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.workflowFileModel.validateSettings(settings);
        this.encryptionKeyModel.validateSettings(settings);
    }

    void validateSettings() throws InvalidSettingsException {
        String workflowFile = this.workflowFileModel.getStringValue();
        if (StringUtils.nullOrEmpty(workflowFile)) {
            throw new InvalidSettingsException("Please configure a workflow");
        }
        Path path = PalladianKnimeHelper.getFileFromUrlOrPath(workflowFile).toPath();
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new InvalidSettingsException("No such file: " + workflowFile);
        }
    }
}

