/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.dist2;

import java.util.Set;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.distance.DistanceMeasure;
import org.knime.distance.DistanceMeasurePortObject;
import org.knime.distance.DistanceMeasurePortSpec;
import org.knime.distance.DistanceMeasurementException;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.helper.dist2.ColumnDistance2Settings;

final class ColumnDistance2NodeModel
extends SimpleStreamableFunctionNodeModel {
    static final int DATA_TABLE_IDX = 0;
    static final int DISTANCE_PORT_IDX = 1;
    private final ColumnDistance2Settings nodeSettings = new ColumnDistance2Settings();
    private DistanceMeasurePortObject distanceMeasurePortObject;

    protected ColumnDistance2NodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, DistanceMeasurePortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE}, 0, 0);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable dataTable = (BufferedDataTable)inObjects[0];
        this.distanceMeasurePortObject = (DistanceMeasurePortObject)inObjects[1];
        ColumnRearranger columnRearranger = this.createColumnRearranger(dataTable.getSpec());
        BufferedDataTable resultTable = exec.createColumnRearrangeTable(dataTable, columnRearranger, (ExecutionMonitor)exec);
        return new PortObject[]{resultTable};
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        final DistanceMeasure measure = this.distanceMeasurePortObject.createDistanceMeasure(dataTableSpec, null);
        String inputCol1 = ColumnDistance2NodeModel.getFirst(this.distanceMeasurePortObject.getSpec().getColumnNames());
        String inputCol2 = this.nodeSettings.secondInputColumn.getStringValue();
        final int inputIdx1 = dataTableSpec.findColumnIndex(inputCol1);
        final int inputIdx2 = dataTableSpec.findColumnIndex(inputCol2);
        DataColumnSpec outSpec = ColumnDistance2NodeModel.createAppendedColumnSpec(inputCol1, inputCol2);
        SingleCellFactory factory = new SingleCellFactory(true, outSpec){

            public DataCell getCell(DataRow row) {
                DataCell[] cellArray = new DataCell[row.getNumCells()];
                int i = 0;
                while (i < row.getNumCells()) {
                    cellArray[i] = row.getCell(i);
                    ++i;
                }
                cellArray[inputIdx1] = cellArray[inputIdx2];
                DefaultRow simulatedRow = new DefaultRow(row.getKey(), cellArray);
                try {
                    double distance = measure.computeDistance(row, (DataRow)simulatedRow);
                    return new DoubleCell(distance);
                }
                catch (DistanceMeasurementException e) {
                    return new MissingCell(e.getMessage());
                }
            }

            public void afterProcessing() {
                ColumnDistance2NodeModel.this.distanceMeasurePortObject = null;
            }
        };
        ColumnRearranger columnRearranger = new ColumnRearranger(dataTableSpec);
        columnRearranger.append((CellFactory)factory);
        return columnRearranger;
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec tableSpec = (DataTableSpec)inSpecs[0];
        DistanceMeasurePortSpec distancePortSpec = (DistanceMeasurePortSpec)inSpecs[1];
        distancePortSpec.validate(tableSpec);
        if (distancePortSpec.getColumnNames().size() != 1) {
            throw new InvalidSettingsException("This node only works for distance measures with one input column.");
        }
        String firstColumnName = ColumnDistance2NodeModel.getFirst(distancePortSpec.getColumnNames());
        DataColumnSpec firstColumnSpec = tableSpec.getColumnSpec(firstColumnName);
        if (StringUtils.nullOrEmpty(this.nodeSettings.secondInputColumn.getStringValue())) {
            DataColumnSpec secondColumnSpec = tableSpec.stream().filter(spec -> !spec.getName().equals(firstColumnName) && spec.getType().equals((Object)firstColumnSpec.getType())).findFirst().orElseThrow(() -> new InvalidSettingsException("No suitable columns found"));
            this.nodeSettings.secondInputColumn.setStringValue(secondColumnSpec.getName());
        } else if (firstColumnName.equals(this.nodeSettings.secondInputColumn.getStringValue())) {
            throw new InvalidSettingsException("Select a different column than '" + firstColumnName + "'");
        }
        DataTableSpec outTableSpec = new DataTableSpecCreator(tableSpec).addColumns(new DataColumnSpec[]{ColumnDistance2NodeModel.createAppendedColumnSpec(ColumnDistance2NodeModel.getFirst(distancePortSpec.getColumnNames()), this.nodeSettings.secondInputColumn.getStringValue())}).createSpec();
        return new PortObjectSpec[]{outTableSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettings(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadSettings(settings);
    }

    static String getFirst(Set<String> set) {
        return (String)set.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Set was empty"));
    }

    private static DataColumnSpec createAppendedColumnSpec(String colName1, String colName2) {
        return new DataColumnSpecCreator("distance (" + colName1 + ", " + colName2 + ")", DoubleCell.TYPE).createSpec();
    }
}

