/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.emptystringtomissing;

import java.util.Arrays;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;

class EmptyStringToMissingValueNodeModel
extends SimpleStreamableFunctionNodeModel {
    EmptyStringToMissingValueNodeModel() {
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        DataColumnSpec[] stringSpecs = (DataColumnSpec[])spec.stream().filter(s -> s.getType().isCompatible(StringValue.class)).toArray(DataColumnSpec[]::new);
        final int[] stringIndices = spec.columnsToIndices((String[])Arrays.stream(stringSpecs).map(DataColumnSpec::getName).toArray(String[]::new));
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        AbstractCellFactory factory = new AbstractCellFactory(true, stringSpecs){

            public DataCell[] getCells(DataRow row) {
                DataCell[] cells = new DataCell[stringIndices.length];
                int i = 0;
                while (i < stringIndices.length) {
                    String stringValue;
                    String trimmedValue;
                    int idx = stringIndices[i];
                    DataCell cell = row.getCell(idx);
                    cells[i] = cell.isMissing() ? cell : ((trimmedValue = (stringValue = ((StringValue)cell).getStringValue()).trim()).isEmpty() ? DataType.getMissingCell() : cell);
                    ++i;
                }
                return cells;
            }
        };
        rearranger.replace((CellFactory)factory, stringIndices);
        return rearranger;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }
}

