/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.math;

import org.knime.core.data.BooleanValue;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.IntValue;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.math.APCalculatorNodeDialog;

public class APCalculatorNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final String CFGKEY_RELEVANT_COLUMN_NAME = "relevantColumnName";
    private final SettingsModelString settingColumnName = APCalculatorNodeDialog.createSettingsColumnn();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec in) throws InvalidSettingsException {
        ColumnRearranger rearranger = new ColumnRearranger(in);
        DataColumnSpec numRelColSpec = new DataColumnSpecCreator("numRel", IntCell.TYPE).createSpec();
        DataColumnSpec pkColSpec = new DataColumnSpecCreator("P@K", DoubleCell.TYPE).createSpec();
        DataColumnSpec apColSpec = new DataColumnSpecCreator("AP", DoubleCell.TYPE).createSpec();
        final int relevanceIndex = in.findColumnIndex(this.settingColumnName.getStringValue());
        AbstractCellFactory factory = new AbstractCellFactory(new DataColumnSpec[]{numRelColSpec, pkColSpec, apColSpec}){
            int numRelevant;
            int k;
            double relPrSum;
            {
                super($anonymous0);
                this.numRelevant = 0;
                this.k = 0;
                this.relPrSum = 0.0;
            }

            public DataCell[] getCells(DataRow row) {
                DataCell relevanceCell = row.getCell(relevanceIndex);
                if (relevanceCell.isMissing()) {
                    return new DataCell[]{DataType.getMissingCell(), DataType.getMissingCell(), DataType.getMissingCell()};
                }
                boolean relevant = APCalculatorNodeModel.this.getRelevanceValue(relevanceCell);
                if (relevant) {
                    ++this.numRelevant;
                }
                double prAtK = (double)this.numRelevant / (double)(++this.k);
                if (relevant) {
                    this.relPrSum += prAtK;
                }
                double ap = this.relPrSum / (double)this.numRelevant;
                return new DataCell[]{new IntCell(this.numRelevant), new DoubleCell(prAtK), new DoubleCell(ap)};
            }
        };
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    private boolean getRelevanceValue(DataCell cell) {
        boolean relevant;
        DataType cellType = cell.getType();
        if (cellType.isCompatible(BooleanValue.class)) {
            relevant = ((BooleanValue)cell).getBooleanValue();
        } else if (cellType.isCompatible(IntValue.class)) {
            relevant = ((IntValue)cell).getIntValue() == 1;
        } else if (cellType.isCompatible(StringValue.class)) {
            relevant = Boolean.valueOf(((StringValue)cell).getStringValue());
        } else {
            throw new IllegalArgumentException("Column type incompatible: " + cellType.toString());
        }
        return relevant;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingColumnName.getStringValue(), BooleanValue.class, IntValue.class, StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, BooleanValue.class, IntValue.class, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingColumnName.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingColumnName.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.validateSettings(settings);
    }
}

