/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.math;

import java.io.File;
import java.io.IOException;
import org.knime.base.node.util.DataArray;
import org.knime.base.node.util.DefaultDataArray;
import org.knime.base.node.viz.plotter.DataProvider;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.ContainerTable;
import org.knime.core.data.container.DataContainer;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.util.ConvenienceMethods;
import ws.palladian.helper.math.ThresholdAnalyzer;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.math.ThresholdAnalyzerNodeDialog;

public class ThresholdAnalyzerNodeModel
extends NodeModel
implements DataProvider {
    private static final NodeLogger logger = NodeLogger.getLogger(ThresholdAnalyzerNodeModel.class);
    private static final int NUM_BINS = 100;
    static final String CFGKEY_CLASS_COLUMN = "classColumn";
    static final String CFGKEY_PROB_COLUMN = "probabilityColumn";
    static final String CFGKEY_POS_VALUE = "positiveClassValue";
    private static final String CFGKEY_FILE_THRESHOLD_DATA = "thresholdData";
    private final SettingsModelString settingClassColumn = ThresholdAnalyzerNodeDialog.createSettingsModelClassColumn();
    private final SettingsModelString settingProbColumn = ThresholdAnalyzerNodeDialog.createSettingsModelProbColumn();
    private final SettingsModelString settingPosClassValue = ThresholdAnalyzerNodeDialog.createSettingsModelClassValue();
    private ThresholdAnalyzer thresholdAnalyzer;
    private DataArray thresholdDataArray;

    protected ThresholdAnalyzerNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = inData[0];
        DataTableSpec inTableSpec = inTable.getDataTableSpec();
        String posClassName = this.settingPosClassValue.getStringValue();
        int classColIndex = inTableSpec.findColumnIndex(this.settingClassColumn.getStringValue());
        int probColIndex = inTableSpec.findColumnIndex(this.settingProbColumn.getStringValue());
        if (classColIndex == -1 || probColIndex == -1) {
            throw new IllegalStateException("Wrong/no column selected for class/probability column; please re-configure the node.");
        }
        this.thresholdAnalyzer = new ThresholdAnalyzer(100);
        long currentRow = 0L;
        for (DataRow dataRow : inTable) {
            if (dataRow.getCell(probColIndex).isMissing() || dataRow.getCell(classColIndex).isMissing()) {
                logger.debug((Object)("Skipping row " + String.valueOf(dataRow.getKey()) + " as probability/class is missing."));
                continue;
            }
            String assignedClass = ((StringValue)dataRow.getCell(classColIndex)).getStringValue();
            double confidence = ((DoubleValue)dataRow.getCell(probColIndex)).getDoubleValue();
            boolean relevant = posClassName.equals(assignedClass);
            this.thresholdAnalyzer.add(relevant, confidence);
            exec.checkCanceled();
            exec.setProgress((double)(currentRow++ / inTable.size()));
        }
        DataTableSpec statsSpec = this.createOutputSpec();
        BufferedDataContainer container = exec.createDataContainer(statsSpec);
        long idx = 0L;
        for (ThresholdAnalyzer.ThresholdEntry entry : this.thresholdAnalyzer) {
            DataCell[] cells = new DataCell[]{new DoubleCell(entry.getThreshold()), new DoubleCell(entry.getPrecision()), new DoubleCell(entry.getRecall()), new DoubleCell(entry.getF1()), new DoubleCell(entry.getAccuracy())};
            container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)idx++), cells));
        }
        container.close();
        BufferedDataTable statsTable = container.getTable();
        this.thresholdDataArray = new DefaultDataArray((DataTable)statsTable, 1, ConvenienceMethods.checkTableSize((long)container.size()));
        return new BufferedDataTable[]{statsTable};
    }

    private DataTableSpec createOutputSpec() {
        DataColumnSpec[] specs = new DataColumnSpec[]{new DataColumnSpecCreator("Threshold", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("Precision", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("Recall", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("F-One", DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator("Accuracy", DoubleCell.TYPE).createSpec()};
        return new DataTableSpec(specs);
    }

    protected void reset() {
        this.thresholdAnalyzer = null;
        this.thresholdDataArray = null;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = this.createOutputSpec();
        return new DataTableSpec[]{spec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingClassColumn.saveSettingsTo(settings);
        this.settingProbColumn.saveSettingsTo(settings);
        this.settingPosClassValue.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingClassColumn.loadSettingsFrom(settings);
        this.settingProbColumn.loadSettingsFrom(settings);
        this.settingPosClassValue.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingClassColumn.validateSettings(settings);
        this.settingProbColumn.validateSettings(settings);
        this.settingPosClassValue.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        File thresholdFile = new File(internDir, CFGKEY_FILE_THRESHOLD_DATA);
        ContainerTable table = DataContainer.readFromZip((File)thresholdFile);
        if (table.size() > Integer.MAX_VALUE) {
            throw new IllegalStateException("More than 2147483647 rows.");
        }
        this.thresholdDataArray = new DefaultDataArray((DataTable)table, 1, (int)table.size());
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        File thresholdFile = new File(internDir, CFGKEY_FILE_THRESHOLD_DATA);
        DataContainer.writeToZip((DataTable)this.thresholdDataArray, (File)thresholdFile, (ExecutionMonitor)exec);
    }

    public DataArray getDataArray(int index) {
        if (index == 0) {
            return this.thresholdDataArray;
        }
        throw new IllegalArgumentException("No DataArray with index " + index);
    }
}

