/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.nlp;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.helper.nlp.CharacterNGramSimilarity;
import ws.palladian.helper.nlp.JaroWinklerSimilarity;
import ws.palladian.helper.nlp.LevenshteinSimilarity;
import ws.palladian.helper.nlp.StringMetric;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.helper.nlp.StringSimilarityNodeDialog;

public class StringSimilarityNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final String CFGKEY_COLUMN_1 = "inputColumn1";
    static final String CFGKEY_COLUMN_2 = "inputColumn2";
    static final String CFGKEY_SIMILARITY = "similarityMeasure";
    static final String CFGKEY_OUTPUT_COLUMN = "similarityColumn";
    static final String DEFAULT_OUTPUT_COLUMN = "Similarity";
    static final SortedMap<String, StringMetric> SIMILARITIES = new TreeMap<String, StringMetric>();
    static final String DEFAULT_SIMILARITY;
    private final SettingsModelString settingColumn1 = StringSimilarityNodeDialog.createSettingsColumn1();
    private final SettingsModelString settingColumn2 = StringSimilarityNodeDialog.createSettingsColumn2();
    private final SettingsModelString settingOutputColumn = StringSimilarityNodeDialog.createSettingsOutputColumn();
    private final SettingsModelString settingSimilarity = StringSimilarityNodeDialog.createSettingsSimilarity();

    static {
        SIMILARITIES.put("Jaro-Winkler", (StringMetric)new JaroWinklerSimilarity());
        SIMILARITIES.put("Levenshtein", (StringMetric)new LevenshteinSimilarity());
        SIMILARITIES.put("2-gram overlap", (StringMetric)new CharacterNGramSimilarity(2));
        SIMILARITIES.put("3-gram overlap", (StringMetric)new CharacterNGramSimilarity(3));
        SIMILARITIES.put("4-gram overlap", (StringMetric)new CharacterNGramSimilarity(4));
        SIMILARITIES.put("5-gram overlap", (StringMetric)new CharacterNGramSimilarity(5));
        SIMILARITIES.put("6-gram overlap", (StringMetric)new CharacterNGramSimilarity(6));
        SIMILARITIES.put("7-gram overlap", (StringMetric)new CharacterNGramSimilarity(7));
        SIMILARITIES.put("8-gram overlap", (StringMetric)new CharacterNGramSimilarity(8));
        SIMILARITIES.put("9-gram overlap", (StringMetric)new CharacterNGramSimilarity(9));
        DEFAULT_SIMILARITY = SIMILARITIES.keySet().iterator().next();
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) throws InvalidSettingsException {
        String outputColName = this.settingOutputColumn.getStringValue();
        DataColumnSpec simSpec = new DataColumnSpecCreator(outputColName, DoubleCell.TYPE).createSpec();
        final int col1idx = dataTableSpec.findColumnIndex(this.settingColumn1.getStringValue());
        final int col2idx = dataTableSpec.findColumnIndex(this.settingColumn2.getStringValue());
        final StringMetric similarityMeasure = (StringMetric)SIMILARITIES.get(this.settingSimilarity.getStringValue());
        SingleCellFactory factory = new SingleCellFactory(simSpec){

            public DataCell getCell(DataRow row) {
                if (row.getCell(col1idx).isMissing() || row.getCell(col2idx).isMissing()) {
                    return DataType.getMissingCell();
                }
                String string1 = ((StringValue)row.getCell(col1idx)).getStringValue();
                String string2 = ((StringValue)row.getCell(col2idx)).getStringValue();
                double similarity = similarityMeasure.getSimilarity((Object)string1, (Object)string2);
                return new DoubleCell(similarity);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String columnName;
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec1 = PalladianKnimeHelper.getColumn(inSpec, this.settingColumn1.getStringValue(), StringValue.class);
        DataColumnSpec columnSpec2 = PalladianKnimeHelper.getColumn(inSpec, this.settingColumn2.getStringValue(), StringValue.class);
        ArrayList<String> guessedColumns = new ArrayList<String>();
        int startIndex = 0;
        if (columnSpec1 == null) {
            columnSpec1 = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            columnName = columnSpec1.getName();
            guessedColumns.add(columnName);
            this.settingColumn1.setStringValue(columnName);
            startIndex = inSpec.findColumnIndex(columnName) + 1;
        }
        if (columnSpec2 == null) {
            columnSpec2 = PalladianKnimeHelper.guessColumn(inSpec, startIndex, StringValue.class);
            columnName = columnSpec2.getName();
            guessedColumns.add(columnName);
            this.settingColumn2.setStringValue(columnName);
        }
        if (guessedColumns.size() > 0) {
            String warningMessage = String.format("Guessed column name(s): %s", StringUtils.join(guessedColumns, (String)", "));
            this.setWarningMessage(warningMessage);
        }
        ColumnRearranger rearranger = this.createColumnRearranger(inSpec);
        return new DataTableSpec[]{rearranger.createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingColumn1.saveSettingsTo(settings);
        this.settingColumn2.saveSettingsTo(settings);
        this.settingOutputColumn.saveSettingsTo(settings);
        this.settingSimilarity.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumn1.loadSettingsFrom(settings);
        this.settingColumn2.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.settingOutputColumn);
        this.settingSimilarity.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumn1.validateSettings(settings);
        this.settingColumn2.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.settingOutputColumn);
        this.settingSimilarity.validateSettings(settings);
    }
}

