/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.helper.testing;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.util.KeyValuePanel;
import ws.palladian.nodes.helper.testing.PreferencesSettings;

class EclipsePreferencesNodeDialog
extends NodeDialogPane {
    private final KeyValuePanel keyValues = new KeyValuePanel();

    protected EclipsePreferencesNodeDialog() {
        this.addTab("Options", this.createOptionsPanel());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add((Component)this.keyValues);
        return panel;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        new PreferencesSettings(this.keyValues.getKeys(), this.keyValues.getValues()).saveSettings(settings);
    }

    protected void loadSettingsFrom(NodeSettingsRO settings, DataTableSpec[] specs) throws NotConfigurableException {
        try {
            PreferencesSettings loadedSettings = new PreferencesSettings(settings);
            this.keyValues.setTableData(loadedSettings.getKeys(), loadedSettings.getValues());
        }
        catch (InvalidSettingsException e) {
            throw new NotConfigurableException("Could not configure. Why?", (Throwable)e);
        }
    }
}

