/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.imageprocessing.trim;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageTrimmer {
    public static BufferedImage trimImage(BufferedImage image) {
        int y;
        int x;
        int width = image.getWidth();
        int height = image.getHeight();
        int left = 0;
        int top = 0;
        int right = width - 1;
        int bottom = height - 1;
        int minRight = width - 1;
        int minBottom = height - 1;
        block0: while (top < bottom) {
            x = 0;
            while (x < width) {
                if (ImageTrimmer.containsPixel(image.getRGB(x, top))) {
                    minRight = x;
                    minBottom = top;
                    break block0;
                }
                ++x;
            }
            ++top;
        }
        block2: while (left < minRight) {
            y = height - 1;
            while (y > top) {
                if (ImageTrimmer.containsPixel(image.getRGB(left, y))) {
                    minBottom = y;
                    break block2;
                }
                --y;
            }
            ++left;
        }
        block4: while (bottom > minBottom) {
            x = width - 1;
            while (x >= left) {
                if (ImageTrimmer.containsPixel(image.getRGB(x, bottom))) {
                    minRight = x;
                    break block4;
                }
                --x;
            }
            --bottom;
        }
        block6: while (right > minRight) {
            y = bottom;
            while (y >= top) {
                if (ImageTrimmer.containsPixel(image.getRGB(right, y))) break block6;
                --y;
            }
            --right;
        }
        return image.getSubimage(left, top, right - left + 1, bottom - top + 1);
    }

    private static boolean containsPixel(int rgba) {
        Color color = new Color(rgba, true);
        if (color.getAlpha() == 0) {
            return false;
        }
        return color.getRed() != 255 || color.getBlue() != 255 || color.getGreen() != 255;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage image = ImageIO.read(ImageTrimmer.class.getResource("JPDRHLKXKNTYQF-UHFFFAOYSA-N_530572.png"));
        BufferedImage trimmedImage = ImageTrimmer.trimImage(image);
        ImageIO.write((RenderedImage)trimmedImage, "png", new File("trimmed.png"));
    }
}

