/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.migration;

import org.knime.core.node.NodeFactory;
import org.knime.workflow.migration.MigrationException;
import org.knime.workflow.migration.MigrationMessage;
import org.knime.workflow.migration.MigrationNodeMatchResult;
import org.knime.workflow.migration.NodeMigrationAction;
import org.knime.workflow.migration.NodeMigrationRule;
import org.knime.workflow.migration.NodeSettingsMigrationManager;
import org.knime.workflow.migration.model.MigrationNode;
import org.knime.workflow.migration.model.MigrationNodePort;
import ws.palladian.nodes.extraction.regex.RegexExtractorNodeFactory;
import ws.palladian.nodes.extraction.regex2.RegexExtractor2NodeFactory;

public class V28RegexExtractorMigrationRule
extends NodeMigrationRule {
    protected Class<? extends NodeFactory<?>> getReplacementNodeFactoryClass(MigrationNode migrationNode, MigrationNodeMatchResult matchResult) {
        return RegexExtractor2NodeFactory.class;
    }

    protected MigrationNodeMatchResult match(MigrationNode migrationNode) {
        boolean matchesFactory = RegexExtractorNodeFactory.class.equals((Object)migrationNode.getOriginalNodeFactoryClass());
        if (!matchesFactory) {
            return MigrationNodeMatchResult.NO_MATCH;
        }
        boolean inputPortConnected = ((MigrationNodePort)migrationNode.getOriginalInputPorts().get(1)).isConnected();
        if (!inputPortConnected) {
            return MigrationNodeMatchResult.NO_MATCH;
        }
        return MigrationNodeMatchResult.of((MigrationNode)migrationNode, (NodeMigrationAction)NodeMigrationAction.REPLACE);
    }

    protected void migrate(MigrationNode migrationNode, MigrationNodeMatchResult matchResult) throws MigrationException {
        this.associateEveryOriginalPortWithNew(migrationNode);
        NodeSettingsMigrationManager settingsManager = this.createSettingsManager(migrationNode);
        settingsManager.copyAllModelAndOptionalVariableSettings(new String[0]).toIdentical();
        settingsManager.copyAllMiscellaneousSettings(new String[0]).toIdentical();
        String mappingType = settingsManager.getSourceModelSettings().getString("mapping", "");
        if (mappingType.startsWith("ROWS")) {
            migrationNode.addFirstMessage(MigrationMessage.Severity.WARNING, "The format of output RowIDs has changed \u2013 instead of incremental IDs (Row0, Row1, Row2, \u2026) the node will use the input row ID suffixed with a running index (Row0, Row1#0, Row1#1, \u2026)");
        }
    }
}

