/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataCellDataInput;
import org.knime.core.data.DataCellDataOutput;
import org.knime.core.data.DataCellSerializer;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import ws.palladian.nodes.retrieval.HttpResultValue;
import ws.palladian.retrieval.HttpResult;

final class HttpResultCellDelegate
implements HttpResultValue,
StringValue,
BinaryObjectDataValue {
    private final HttpResult httpResult;

    HttpResultCellDelegate(HttpResult httpResult) {
        this.httpResult = httpResult;
    }

    public boolean equalsDataCell(DataCell dc) {
        if (dc != null && dc.getType().isCompatible(HttpResultValue.class)) {
            return ((HttpResultValue)dc).getHttpResult().equals(this.httpResult);
        }
        return false;
    }

    @Override
    public HttpResult getHttpResult() {
        return this.httpResult;
    }

    public String getStringValue() {
        return this.httpResult.getContent() != null ? this.httpResult.getStringContent() : null;
    }

    public long length() {
        return this.httpResult.getContent().length;
    }

    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.httpResult.getContent());
    }

    public String toString() {
        return this.httpResult.getStringContent();
    }

    public int hashCode() {
        return this.httpResult.hashCode();
    }

    static abstract class AbstractHttpResultCellSerializer<C extends DataCell>
    implements DataCellSerializer<C> {
        AbstractHttpResultCellSerializer() {
        }

        public final void serialize(C cell, DataCellDataOutput output) throws IOException {
            HttpResult httpResult = ((HttpResultValue)cell).getHttpResult();
            output.writeUTF(httpResult.getUrl());
            output.writeInt(httpResult.getContent().length);
            output.write(httpResult.getContent());
            Map headers = httpResult.getHeaders();
            output.writeInt(headers.size());
            for (Map.Entry entry : headers.entrySet()) {
                output.writeUTF((String)entry.getKey());
                output.writeInt(((List)entry.getValue()).size());
                for (String headerValue : (List)entry.getValue()) {
                    output.writeUTF(headerValue);
                }
            }
            output.writeInt(httpResult.getStatusCode());
            output.writeLong(httpResult.getTransferedBytes());
            List locations = httpResult.getLocations();
            output.writeInt(locations.size());
            for (String location : locations) {
                output.writeUTF(location);
            }
        }

        public final C deserialize(DataCellDataInput input) throws IOException {
            HttpResult httpResult = AbstractHttpResultCellSerializer.deserializeHttpResult(input);
            return this.createCell(httpResult);
        }

        protected abstract C createCell(HttpResult var1);

        private static HttpResult deserializeHttpResult(DataCellDataInput input) throws IOException {
            String url = input.readUTF();
            int contentLength = input.readInt();
            byte[] content = new byte[contentLength];
            input.readFully(content);
            LinkedHashMap headers = new LinkedHashMap();
            int numHeaderEntries = input.readInt();
            int headerEntryIdx = 0;
            while (headerEntryIdx < numHeaderEntries) {
                String headerKey = input.readUTF();
                int numHeaderValues = input.readInt();
                ArrayList<String> headerValues = new ArrayList<String>();
                int headerValueIdx = 0;
                while (headerValueIdx < numHeaderValues) {
                    String headerValue = input.readUTF();
                    headerValues.add(headerValue);
                    ++headerValueIdx;
                }
                headers.put(headerKey, headerValues);
                ++headerEntryIdx;
            }
            int statusCode = input.readInt();
            long transferedBytes = input.readLong();
            ArrayList<String> locations = new ArrayList<String>();
            try {
                int numLocationEntries = input.readInt();
                int locationEntryIdx = 0;
                while (locationEntryIdx < numLocationEntries) {
                    locations.add(input.readUTF());
                    ++locationEntryIdx;
                }
            }
            catch (IOException iOException) {}
            return new HttpResult(url, content, headers, statusCode, transferedBytes, locations);
        }
    }
}

