/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataType;
import org.knime.core.node.NodeLogger;
import ws.palladian.nodes.retrieval.HttpResultBlobCell;
import ws.palladian.nodes.retrieval.HttpResultCell2;
import ws.palladian.retrieval.HttpResult;

public final class HttpResultCellFactory {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(HttpResultCellFactory.class);
    private static final long MIN_BLOB_SIZE = 8192L;

    public static DataCell createCell(HttpResult httpResult) {
        if (httpResult == null) {
            LOGGER.debug((Object)"HttpResultCellFactory#createCell: MissingCell");
            return DataType.getMissingCell();
        }
        if (httpResult.getTransferedBytes() < 8192L) {
            LOGGER.debug((Object)"HttpResultCellFactory#createCell: HttpResultCell2");
            return new HttpResultCell2(httpResult);
        }
        LOGGER.debug((Object)"HttpResultCellFactory#createCell: HttpResultBlobCell");
        return new HttpResultBlobCell(httpResult);
    }

    private HttpResultCellFactory() {
    }
}

