/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.util.List;
import java.util.Map;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.renderer.AbstractDataValueRendererFactory;
import org.knime.core.data.renderer.DataValueRenderer;
import org.knime.core.data.renderer.MultiLineStringValueRenderer;
import ws.palladian.nodes.retrieval.HttpResultValue;
import ws.palladian.retrieval.HttpResult;

public final class HttpResultValueRenderer2
extends MultiLineStringValueRenderer {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = new String(new char[80]).replace("\u0000", "-");
    private final int lengthLimit;

    private HttpResultValueRenderer2(String description, int lengthLimit) {
        super(description);
        this.lengthLimit = lengthLimit;
    }

    protected void setValue(Object value) {
        if (value instanceof HttpResultValue) {
            HttpResultValue httpResultValue = (HttpResultValue)value;
            HttpResult httpResult = httpResultValue.getHttpResult();
            StringBuilder builder = new StringBuilder();
            builder.append("Status: ").append(httpResult.getStatusCode()).append('\n');
            builder.append("Locations:").append('\n');
            for (String string : httpResult.getLocations()) {
                builder.append(string).append('\n');
            }
            builder.append(SEPARATOR).append('\n');
            for (Map.Entry entry : httpResult.getHeaders().entrySet()) {
                builder.append((String)entry.getKey()).append(": ");
                boolean first = true;
                for (String headerValue : (List)entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append("; ");
                    }
                    builder.append(headerValue);
                }
                builder.append('\n');
            }
            builder.append(SEPARATOR).append('\n');
            builder.append(httpResult.getStringContent());
            if (this.lengthLimit > 0 && builder.length() > this.lengthLimit) {
                builder.setLength(this.lengthLimit);
                builder.append(" [\u2026]");
            }
            super.setValue((Object)builder.toString());
        } else {
            super.setValue(value);
        }
    }

    public static final class Factory
    extends AbstractDataValueRendererFactory {
        public String getDescription() {
            return "HTTP Result (first 1000 characters)";
        }

        public DataValueRenderer createRenderer(DataColumnSpec colSpec) {
            return new HttpResultValueRenderer2(this.getDescription(), 1000);
        }
    }

    public static final class FactoryFull
    extends AbstractDataValueRendererFactory {
        public String getDescription() {
            return "HTTP Result (full)";
        }

        public DataValueRenderer createRenderer(DataColumnSpec colSpec) {
            return new HttpResultValueRenderer2(this.getDescription(), -1);
        }
    }
}

