/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectDataValue;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnFilter2;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentNumberEdit;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;

public class HttpRetrieverNodeDialog2
extends DefaultNodeSettingsPane {
    private final HttpRetrieverNodeSettings httpRetrieverSettings = new HttpRetrieverNodeSettings();

    protected HttpRetrieverNodeDialog2() {
        this.setDefaultTabTitle("General");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.httpRetrieverSettings.urlColumnName, "URL input", 0, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.httpRetrieverSettings.methodColumnName, "HTTP method input (default: GET)", 0, false, true, new Class[]{StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.httpRetrieverSettings.entityColumnName, "HTTP entity input (optional)", 0, false, true, new Class[]{BinaryObjectDataValue.class, StringValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.httpRetrieverSettings.entityContentType, "HTTP entity content type", HttpRetrieverNodeSettings.ENTITY_CONTENT_TYPES, true));
        DialogComponentBoolean sizeLimit = new DialogComponentBoolean(this.httpRetrieverSettings.sizeLimit, "Enable file size limitation");
        this.addDialogComponent((DialogComponent)sizeLimit);
        DialogComponentNumber maxSize = new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.maxSize, "Maximum file size (kB)", (Number)512);
        this.addDialogComponent((DialogComponent)maxSize);
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.addStatusCode, "Append column with HTTP status code"));
        this.createNewTab("Headers");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnFilter2(this.httpRetrieverSettings.getHeaderFilter(), 0));
        this.createNewTab("Advanced");
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.numRetries, "# retries after error (for each URL)", (Number)1));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.connectionTimeout, "Connection timeout (ms)", (Number)1000, 6));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.httpRetrieverSettings.socketTimeout, "Socket timeout (ms)", (Number)1000, 6));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.httpRetrieverSettings.userAgent, "User agent", true, 15));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.acceptAllCerts, "Accept all SSL certificates (only enable this if you understand the implications!)"));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.failOnNonSuccessStatusCode, "Fail on non-success HTTP status code (>= 400)"));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.failOnNetworkError, "Fail on network error"));
        this.createNewTab("Proxy");
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.httpRetrieverSettings.useCustomProxy, "Use custom proxy server (override system default)"));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.httpRetrieverSettings.proxyHost, "Host"));
        this.addDialogComponent((DialogComponent)new DialogComponentNumberEdit((SettingsModelNumber)this.httpRetrieverSettings.proxyPort, "Port", 5));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.httpRetrieverSettings.proxyUsername, "Username"));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.httpRetrieverSettings.proxyPassword, "Password"));
    }
}

