/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpRetrieverCellFactory;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;

public class HttpRetrieverNodeModel
extends NodeModel {
    private final HttpRetrieverNodeSettings httpRetrieverSettings = new HttpRetrieverNodeSettings();

    protected HttpRetrieverNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable table = inData[0];
        ColumnRearranger rearranger = this.createColumnRearranger(table.getDataTableSpec());
        BufferedDataTable out = exec.createColumnRearrangeTable(table, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec) {
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        rearranger.append((CellFactory)this.httpRetrieverSettings.createCellFactory(dataTableSpec, null));
        return rearranger;
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.httpRetrieverSettings.urlColumnName.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.httpRetrieverSettings.urlColumnName.setStringValue(columnName);
        }
        DataColumnSpec[] addedColumns = HttpRetrieverCellFactory.createSpec(this.httpRetrieverSettings.addStatusCode.getBooleanValue());
        DataTableSpec outSpec = new DataTableSpecCreator(inSpec).addColumns(addedColumns).createSpec();
        return new DataTableSpec[]{outSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.httpRetrieverSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.httpRetrieverSettings.loadValidatedSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.httpRetrieverSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

