/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval;

import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortType;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.HttpRetrieverCellFactory;
import ws.palladian.nodes.retrieval.HttpRetrieverNodeSettings;
import ws.palladian.nodes.retrieval.ThreadSafeCookieStore;
import ws.palladian.retrieval.Cookie;
import ws.palladian.retrieval.CookieStore;
import ws.palladian.retrieval.ImmutableCookie;

public class HttpRetrieverNodeModel2
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(HttpRetrieverNodeModel2.class);
    static final int URL_INPUT_TABLE = 0;
    private static final int COOKIE_INPUT_TABLE = 1;
    private static final String COOKIE_COLUMN_VALUE = "Value";
    private static final String COOKIE_COLUMN_NAME = "Name";
    private static final String COOKIE_COLUMN_PATH = "Path";
    private static final String COOKIE_COLUMN_DOMAIN = "Domain";
    private final HttpRetrieverNodeSettings httpRetrieverSettings = new HttpRetrieverNodeSettings();

    protected HttpRetrieverNodeModel2() {
        super(new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE});
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable urlsTable = inData[0];
        BufferedDataTable cookiesTable = inData[1];
        ThreadSafeCookieStore cookieStore = new ThreadSafeCookieStore();
        if (cookiesTable != null) {
            cookieStore = this.readCookieStore(cookiesTable, cookieStore);
        }
        ColumnRearranger rearranger = this.createColumnRearranger(urlsTable.getDataTableSpec(), cookieStore);
        BufferedDataTable resultTable = exec.createColumnRearrangeTable(urlsTable, rearranger, (ExecutionMonitor)exec);
        BufferedDataTable cookieTable = this.createCookiesTable(exec, cookieStore);
        return new BufferedDataTable[]{resultTable, cookieTable};
    }

    private CookieStore readCookieStore(BufferedDataTable cookiesTable, CookieStore cookieStore) {
        DataTableSpec spec = cookiesTable.getDataTableSpec();
        int domainIdx = spec.findColumnIndex(COOKIE_COLUMN_DOMAIN);
        int pathIdx = spec.findColumnIndex(COOKIE_COLUMN_PATH);
        int nameIdx = spec.findColumnIndex(COOKIE_COLUMN_NAME);
        int valueIdx = spec.findColumnIndex(COOKIE_COLUMN_VALUE);
        for (DataRow row : cookiesTable) {
            DataCell domainCell = row.getCell(domainIdx);
            DataCell pathCell = row.getCell(pathIdx);
            DataCell nameCell = row.getCell(nameIdx);
            DataCell valueCell = row.getCell(valueIdx);
            if (PalladianKnimeHelper.anyMissing(domainCell, nameCell, valueCell)) {
                logger.warn((Object)("Row " + String.valueOf(row.getKey()) + " in cookies table was missing necessary values (domain, name, or value)."));
                continue;
            }
            String domain = PalladianKnimeHelper.getString(domainCell);
            String path = PalladianKnimeHelper.getString(pathCell);
            String name = PalladianKnimeHelper.getString(nameCell);
            String value = PalladianKnimeHelper.getString(valueCell);
            cookieStore.addCookie((Cookie)new ImmutableCookie(name, value, domain, path));
        }
        logger.debug((Object)("Read " + cookieStore.getCookies().size() + " cookies."));
        return cookieStore;
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec, CookieStore cookieStore) {
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        rearranger.append((CellFactory)new HttpRetrieverCellFactory(dataTableSpec, cookieStore, this.httpRetrieverSettings){

            @Override
            public void setWarningMessageAfterProcessing(String message) {
                HttpRetrieverNodeModel2.this.setWarningMessage(message);
            }
        });
        return rearranger;
    }

    private BufferedDataTable createCookiesTable(ExecutionContext exec, CookieStore cookieStore) throws CanceledExecutionException {
        DataTableSpec outputSpec = this.createCookiesTableSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        exec.setProgress("Creating cookies table");
        long rowIdx = 0L;
        for (Cookie cookie : cookieStore.getCookies()) {
            RowKey key = RowKey.createRowKey((long)rowIdx++);
            DataCell[] cells = new DataCell[]{new StringCell(cookie.getDomain()), new StringCell(cookie.getPath()), new StringCell(cookie.getName()), new StringCell(cookie.getValue())};
            container.addRowToTable((DataRow)new DefaultRow(key, cells));
            exec.checkCanceled();
        }
        container.close();
        return container.getTable();
    }

    private DataTableSpec createCookiesTableSpec() {
        DataColumnSpec[] colSpecs = new DataColumnSpec[]{new DataColumnSpecCreator(COOKIE_COLUMN_DOMAIN, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(COOKIE_COLUMN_PATH, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(COOKIE_COLUMN_NAME, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(COOKIE_COLUMN_VALUE, StringCell.TYPE).createSpec()};
        return new DataTableSpec(colSpecs);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec urlInSpec = inSpecs[0];
        DataTableSpec cookieInSpec = inSpecs[1];
        DataColumnSpec resultColSpec = PalladianKnimeHelper.getColumn(urlInSpec, this.httpRetrieverSettings.urlColumnName.getStringValue(), StringValue.class);
        if (resultColSpec == null) {
            resultColSpec = PalladianKnimeHelper.guessColumn(urlInSpec, StringValue.class);
            String columnName = resultColSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.httpRetrieverSettings.urlColumnName.setStringValue(columnName);
        }
        if (cookieInSpec != null) {
            PalladianKnimeHelper.checkHasColumn(cookieInSpec, COOKIE_COLUMN_DOMAIN, StringValue.class);
            PalladianKnimeHelper.checkHasColumn(cookieInSpec, COOKIE_COLUMN_PATH, StringValue.class);
            PalladianKnimeHelper.checkHasColumn(cookieInSpec, COOKIE_COLUMN_NAME, StringValue.class);
            PalladianKnimeHelper.checkHasColumn(cookieInSpec, COOKIE_COLUMN_VALUE, StringValue.class);
        }
        this.httpRetrieverSettings.configHeaderFilter(urlInSpec);
        DataTableSpec cookieOutSpec = this.createCookiesTableSpec();
        DataTableSpec resultOutSpec = new DataTableSpecCreator(urlInSpec).addColumns(HttpRetrieverCellFactory.createSpec(this.httpRetrieverSettings.addStatusCode.getBooleanValue())).createSpec();
        return new DataTableSpec[]{resultOutSpec, cookieOutSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.httpRetrieverSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.httpRetrieverSettings.loadValidatedSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.httpRetrieverSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

