/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ip;

import ws.palladian.helper.collection.LruMap;
import ws.palladian.retrieval.ip.IpLookup;
import ws.palladian.retrieval.ip.IpLookupException;
import ws.palladian.retrieval.ip.IpLookupResult;

public class CachedIpLookup
implements IpLookup {
    public static final int DEFAULT_CACHE_SIZE = 1000;
    private final IpLookup source;
    private final LruMap<String, IpLookupResult> cache;

    public CachedIpLookup(IpLookup source) {
        this(source, 1000);
    }

    public CachedIpLookup(IpLookup source, int cacheSize) {
        if (source == null) {
            throw new NullPointerException("source was null");
        }
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("cacheSize must be greater zero");
        }
        this.source = source;
        this.cache = LruMap.accessOrder((int)cacheSize);
    }

    public IpLookupResult lookup(String ip) throws IpLookupException {
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("ip was null or empty");
        }
        IpLookupResult value = (IpLookupResult)this.cache.get((Object)ip);
        if (value == null) {
            value = this.source.lookup(ip);
            this.cache.put((Object)ip, (Object)value);
        }
        return value;
    }
}

