/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.ranking;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.AbstractCellFactory;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.defaultnodesettings.SettingsModelStringArray;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.ApacheConfigurationAdapter;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.ranking.RankingServicesNodeDialog;
import ws.palladian.retrieval.ranking.Ranking;
import ws.palladian.retrieval.ranking.RankingService;
import ws.palladian.retrieval.ranking.RankingType;
import ws.palladian.retrieval.ranking.services.BibsonomyBookmarks;
import ws.palladian.retrieval.ranking.services.CompositeRankingService;
import ws.palladian.retrieval.ranking.services.HackerNewsRankingService;
import ws.palladian.retrieval.ranking.services.PinterestPins;
import ws.palladian.retrieval.ranking.services.RedditStats;

@Deprecated
public class RankingServicesNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(RankingServicesNodeModel.class);
    private static final String SERVICE_ALEXA = "Alexa";
    private static final String SERVICE_BIBSONOMY = "Bibsonomy";
    private static final String SERVICE_BITLY = "Bitly";
    private static final String SERVICE_FACEBOOK = "Facebook";
    private static final String SERVICE_GOOGLE = "Google PageRank";
    private static final String SERVICE_HACKER_NEWS = "Hacker News";
    private static final String SERVICE_MAJESTIC = "Majestic SEO";
    private static final String SERVICE_PLURK = "Plurk";
    private static final String SERVICE_REDDIT = "Reddit";
    private static final String SERVICE_SHARETHIS = "ShareThis";
    private static final String SERVICE_WEBOFTRUST = "Web of Trust";
    private static final String SERVICE_GOOGLE_PLUS = "Google Plus";
    private static final String SERVICE_YANDEX = "Yandex";
    private static final String SERVICE_GOOGLE_CACHE = "Google Cached Page";
    private static final String SERVICE_LINKED_IN = "Linked In";
    private static final String SERVICE_PINTEREST = "Pinterest";
    private static final String SERVICE_SEMRUSH = "SemRush";
    private static final String SERVICE_STUMBLE_UPON = "Stumble Upon";
    private static final String SERVICE_WEBUTATION = "Webutation";
    static final List<String> SERVICES = Arrays.asList("Alexa", "Bibsonomy", "Bitly", "Facebook", "Google PageRank", "Hacker News", "Majestic SEO", "Plurk", "Reddit", "ShareThis", "Web of Trust", "Google Plus", "Yandex", "Google Cached Page", "Linked In", "Pinterest", "SemRush", "Stumble Upon", "Webutation");
    static final String CFGKEY_SERVICE = "rankingServices";
    static final String CFGKEY_URL_COLUMN_NAME = "urlColumnName";
    private final SettingsModelStringArray settingsServices = RankingServicesNodeDialog.createSettingsModelService();
    private final SettingsModelString settingsUrlColumn = RankingServicesNodeDialog.createSettingsUrlColumnName();

    static {
        Collections.sort(SERVICES);
    }

    protected RankingServicesNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = inData[0];
        CompositeRankingService compositeRankingService = this.createCompositeRankingService();
        ColumnRearranger rearranger = this.createColumnRearranger(inTable.getDataTableSpec(), compositeRankingService);
        BufferedDataTable out = exec.createColumnRearrangeTable(inTable, rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    private CompositeRankingService createCompositeRankingService() {
        ArrayList<RankingService> temp = new ArrayList<RankingService>();
        String[] selectedServices = this.settingsServices.getStringArrayValue();
        IPreferenceStore prefStore = PalladianPluginActivator.getDefault().getPreferenceStore();
        ApacheConfigurationAdapter config = new ApacheConfigurationAdapter(prefStore);
        if (selectedServices != null) {
            String[] stringArray = selectedServices;
            int n = selectedServices.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                RankingService rankingService = this.createService(service, config);
                if (rankingService != null) {
                    temp.add(rankingService);
                }
                ++n2;
            }
        }
        logger.debug((Object)("ranking services: " + String.valueOf(temp)));
        return new CompositeRankingService(temp);
    }

    private RankingService createService(String service, Configuration config) {
        BibsonomyBookmarks ret = null;
        try {
            if (SERVICE_ALEXA.equals(service)) {
                throw new IllegalArgumentException("Alexa is no longer supported");
            }
            if (SERVICE_BIBSONOMY.equals(service)) {
                ret = new BibsonomyBookmarks(config);
            } else {
                if (SERVICE_BITLY.equals(service)) {
                    throw new IllegalArgumentException("Bitly is no longer supported");
                }
                if (SERVICE_GOOGLE.equals(service)) {
                    throw new IllegalArgumentException("Google PageRank is no longer supported");
                }
                if (SERVICE_MAJESTIC.equals(service)) {
                    throw new IllegalArgumentException("Majestic SEO is no longer supported");
                }
                if (SERVICE_HACKER_NEWS.equals(service)) {
                    ret = new HackerNewsRankingService();
                } else {
                    if (SERVICE_PLURK.equals(service)) {
                        throw new IllegalArgumentException("Plurk is no longer supported");
                    }
                    if (SERVICE_REDDIT.equals(service)) {
                        ret = new RedditStats();
                    } else {
                        if (SERVICE_SHARETHIS.equals(service)) {
                            throw new IllegalArgumentException("ShareThis is no longer supported");
                        }
                        if (SERVICE_WEBOFTRUST.equals(service)) {
                            throw new IllegalArgumentException("Web of Trust is no longer supported");
                        }
                        if (SERVICE_GOOGLE_PLUS.equals(service)) {
                            throw new IllegalArgumentException("Google Plus is no longer supported");
                        }
                        if (SERVICE_YANDEX.equals(service)) {
                            throw new IllegalArgumentException("Yandex is no longer supported");
                        }
                        if (SERVICE_GOOGLE_CACHE.equals(service)) {
                            throw new IllegalArgumentException("Google Cached Page is no longer supported");
                        }
                        if (SERVICE_LINKED_IN.equals(service)) {
                            throw new IllegalArgumentException("Linked In is no longer supported");
                        }
                        if (SERVICE_PINTEREST.equals(service)) {
                            ret = new PinterestPins();
                        } else {
                            if (SERVICE_SEMRUSH.equals(service)) {
                                throw new IllegalArgumentException("SemRush is no longer supported");
                            }
                            if (SERVICE_STUMBLE_UPON.equals(service)) {
                                throw new IllegalArgumentException("Stumble Upon is no longer supported");
                            }
                            if (SERVICE_WEBUTATION.equals(service)) {
                                throw new IllegalArgumentException("Webutation is no longer supported");
                            }
                            logger.error((Object)("Unknown ranking service: " + service));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error creating " + service + ": " + e.getMessage()));
        }
        return ret;
    }

    private ColumnRearranger createColumnRearranger(DataTableSpec dataTableSpec, final CompositeRankingService compositeRankingService) {
        ColumnRearranger rearranger = new ColumnRearranger(dataTableSpec);
        final List rankingTypes = compositeRankingService.getRankingTypes();
        String inputColumnName = this.settingsUrlColumn.getStringValue();
        ArrayList<DataColumnSpec> rankingColumnSpecs = new ArrayList<DataColumnSpec>();
        for (RankingType rankingType : rankingTypes) {
            rankingColumnSpecs.add(new DataColumnSpecCreator(DataTableSpec.getUniqueColumnName((DataTableSpec)dataTableSpec, (String)(inputColumnName + ": " + rankingType.getName())), DoubleCell.TYPE).createSpec());
        }
        final int inputColumnIndex = dataTableSpec.findColumnIndex(inputColumnName);
        AbstractCellFactory factory = new AbstractCellFactory(rankingColumnSpecs.toArray(new DataColumnSpec[0])){

            public DataCell[] getCells(DataRow row) {
                DataCell cell = row.getCell(inputColumnIndex);
                if (cell.isMissing()) {
                    return Collections.nCopies(rankingTypes.size(), DataType.getMissingCell()).toArray(new DataCell[0]);
                }
                String url = ((StringValue)cell).getStringValue();
                Ranking ranking = compositeRankingService.getRanking(url);
                logger.debug((Object)("ranking for " + url + " : " + String.valueOf(ranking)));
                ArrayList<Object> cells = new ArrayList<Object>();
                Map rankingValues = ranking.getValues();
                for (RankingType rankingType : rankingTypes) {
                    Number rankingValue = (Number)rankingValues.get(rankingType);
                    if (rankingValue != null) {
                        cells.add(new DoubleCell(rankingValue.doubleValue()));
                        continue;
                    }
                    cells.add(DataType.getMissingCell());
                }
                return cells.toArray(new DataCell[0]);
            }
        };
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingsUrlColumn.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingsUrlColumn.setStringValue(columnName);
        }
        return new DataTableSpec[]{this.createColumnRearranger(inSpec, this.createCompositeRankingService()).createSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingsServices.saveSettingsTo(settings);
        this.settingsUrlColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsServices.loadSettingsFrom(settings);
        this.settingsUrlColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingsServices.validateSettings(settings);
        this.settingsUrlColumn.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

