/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import net.jodah.typetools.TypeResolver;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.SetCell;
import org.knime.core.data.date.DateAndTimeCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.helper.ApacheConfigurationAdapter;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.search.WebSearcherNodeDialog;
import ws.palladian.retrieval.resources.WebContent;
import ws.palladian.retrieval.resources.WebImage;
import ws.palladian.retrieval.resources.WebVideo;
import ws.palladian.retrieval.search.MultifacetQuery;
import ws.palladian.retrieval.search.SearchResults;
import ws.palladian.retrieval.search.Searcher;
import ws.palladian.retrieval.search.SearcherFactory;
import ws.palladian.retrieval.search.images.FlickrSearcher;
import ws.palladian.retrieval.search.videos.YouTubeSearcher;
import ws.palladian.retrieval.search.web.GoogleProgrammableSearchEngine;
import ws.palladian.retrieval.search.web.WikipediaSearcher;

@Deprecated
public class WebSearcherNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(WebSearcherNodeModel.class);
    static final String CFGKEY_QUERY_COLUMN_NAME = "queryColumnName";
    static final String CFGKEY_NUM_RESULTS = "resultCount";
    static final String CFGKEY_SEARCH_ENGINE = "searchEngine";
    static final String CFGKEY_SEARCH_LANGUAGE = "searchLanguage";
    static final String CFGKEY_APPEND_TOTAL_RESULT_COUNT = "appendTotalResultCount";
    static final Map<String, Class<? extends Searcher<?>>> SEARCHERS;
    static final Map<String, Language> LANGUAGES;
    static final String DEFAULT_SEARCHER;
    static final int DEFAULT_COUNT_RESULTS = 10;
    static final String DEFAULT_LANGUAGE;
    private final SettingsModelString settingColumnName = new SettingsModelString("queryColumnName", null);
    private final SettingsModelString settingSearchEngine = WebSearcherNodeDialog.createSettingsSearcher();
    private final SettingsModelIntegerBounded settingNumResults = WebSearcherNodeDialog.createSettingsNumResults();
    private final SettingsModelString settingSearchLanguage = WebSearcherNodeDialog.createSettingsLanguage();
    private final SettingsModelBoolean settingAppendTotalResultCount = WebSearcherNodeDialog.createSettingsAppendTotalResultCount();

    static {
        TreeMap<String, Class> availableSearchers = new TreeMap<String, Class>();
        availableSearchers.put("Flickr", FlickrSearcher.class);
        availableSearchers.put("Google Custom Search", GoogleProgrammableSearchEngine.class);
        availableSearchers.put("Wikipedia", WikipediaSearcher.class);
        availableSearchers.put("YouTube", YouTubeSearcher.class);
        SEARCHERS = Collections.unmodifiableMap(availableSearchers);
        TreeMap<String, Language> availableLanguages = new TreeMap<String, Language>();
        for (Language language : Language.TEN_MOST_SPOKEN) {
            availableLanguages.put(language.getName(), language);
        }
        LANGUAGES = Collections.unmodifiableMap(availableLanguages);
        DEFAULT_SEARCHER = SEARCHERS.keySet().iterator().next();
        DEFAULT_LANGUAGE = Language.ENGLISH.getName();
    }

    protected WebSearcherNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        Configuration configuration = this.getConfiguration();
        Class<? extends Searcher<?>> searcherClass = SEARCHERS.get(this.settingSearchEngine.getStringValue());
        if (searcherClass == null) {
            throw new IllegalArgumentException("No searcher with name \"" + this.settingSearchEngine.getStringValue() + "\".");
        }
        Searcher<?> searcher = this.createSearcher(searcherClass, configuration);
        Language language = LANGUAGES.get(this.settingSearchLanguage.getStringValue());
        DataTableSpec outputSpec = this.createOutputSpec();
        BufferedDataContainer buf = exec.createDataContainer(outputSpec);
        BufferedDataTable inputTable = inData[0];
        long inRowCount = inputTable.size();
        long inRowIndex = 0L;
        long outRowIndex = 0L;
        int queryColumnIndex = inputTable.getSpec().findColumnIndex(this.settingColumnName.getStringValue());
        Class<?> resultType = this.getResultType();
        if (queryColumnIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + queryColumnIndex + "). Please (re)configure the node correctly.");
        }
        for (DataRow inRow : inputTable) {
            ++inRowIndex;
            DataCell cell = inRow.getCell(queryColumnIndex);
            if (cell.isMissing()) {
                logger.debug((Object)("skipping row with missing value (" + String.valueOf(inRow.getKey()) + ")"));
                continue;
            }
            String query = ((StringValue)cell).getStringValue();
            logger.debug((Object)("searching:" + query + " language:" + String.valueOf(language) + " results:" + this.settingNumResults.getIntValue()));
            MultifacetQuery.Builder queryBuilder = new MultifacetQuery.Builder();
            queryBuilder.setText(query);
            queryBuilder.setResultCount(this.settingNumResults.getIntValue());
            queryBuilder.setLanguage(language);
            SearchResults webResults = searcher.search(queryBuilder.create());
            for (WebContent webResult : webResults) {
                RowKey key = RowKey.createRowKey((long)outRowIndex++);
                ArrayList<Object> cells = new ArrayList<Object>();
                cells.add(new StringCell(query));
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getTitle()));
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getSummary()));
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getUrl()));
                cells.add(PalladianKnimeHelper.createDateAndTime(webResult.getPublished()));
                if (webResult.getTags() != null) {
                    HashSet<StringCell> tags = new HashSet<StringCell>();
                    for (String tag : webResult.getTags()) {
                        tags.add(new StringCell(tag));
                    }
                    cells.add(CollectionCellFactory.createSetCell(tags));
                } else {
                    cells.add(DataType.getMissingCell());
                }
                if (webResult.getCoordinate() != null) {
                    cells.add(new GeoCoordinateCell(webResult.getCoordinate()));
                } else {
                    cells.add(DataType.getMissingCell());
                }
                if (WebImage.class.isAssignableFrom(resultType)) {
                    WebImage webImage = (WebImage)webResult;
                    cells.add(PalladianKnimeHelper.createStringCell(webImage.getImageUrl()));
                    cells.add(PalladianKnimeHelper.createStringCell(webImage.getThumbnailUrl()));
                    cells.add(webImage.getWidth() != -1 ? new IntCell(webImage.getWidth()) : DataType.getMissingCell());
                    cells.add(webImage.getHeight() != -1 ? new IntCell(webImage.getHeight()) : DataType.getMissingCell());
                    cells.add(webImage.getSize() != -1 ? new IntCell(webImage.getSize()) : DataType.getMissingCell());
                }
                if (WebVideo.class.isAssignableFrom(resultType)) {
                    WebVideo webVideo = (WebVideo)webResult;
                    cells.add(PalladianKnimeHelper.createStringCell(webVideo.getVideoUrl()));
                    cells.add(PalladianKnimeHelper.createStringCell(webVideo.getThumbnailUrl()));
                    cells.add(webVideo.getDuration() != null ? new IntCell(webVideo.getDuration().intValue()) : DataType.getMissingCell());
                }
                if (this.settingAppendTotalResultCount.getBooleanValue()) {
                    Long totalResults = webResults.getResultCount();
                    if (totalResults != null) {
                        cells.add(new LongCell(totalResults.longValue()));
                    } else {
                        cells.add(DataType.getMissingCell());
                    }
                }
                DefaultRow outRow = new DefaultRow(key, cells);
                buf.addRowToTable((DataRow)outRow);
            }
            exec.checkCanceled();
            exec.setProgress((double)inRowIndex / (double)inRowCount, "Searched for " + query);
        }
        buf.close();
        BufferedDataTable outTable = buf.getTable();
        return new BufferedDataTable[]{outTable};
    }

    private DataTableSpec createOutputSpec() {
        Class<?> searchResultType = this.getResultType();
        boolean addTotalCount = this.settingAppendTotalResultCount.getBooleanValue();
        ArrayList<DataColumnSpec> allColSpecs = new ArrayList<DataColumnSpec>();
        allColSpecs.add(new DataColumnSpecCreator("Query", StringCell.TYPE).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("Title", StringCell.TYPE).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("Summary", StringCell.TYPE).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("URL", StringCell.TYPE).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("Date", DateAndTimeCell.TYPE).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("Tags", SetCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        allColSpecs.add(new DataColumnSpecCreator("Coordinate", GeoCoordinateCell.TYPE).createSpec());
        if (WebImage.class.isAssignableFrom(searchResultType)) {
            allColSpecs.add(new DataColumnSpecCreator("Image URL", StringCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Thumbnail URL", StringCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Width", IntCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Height", IntCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Size", IntCell.TYPE).createSpec());
        }
        if (WebVideo.class.isAssignableFrom(searchResultType)) {
            allColSpecs.add(new DataColumnSpecCreator("Video URL", StringCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Thumbnail URL", StringCell.TYPE).createSpec());
            allColSpecs.add(new DataColumnSpecCreator("Duration", IntCell.TYPE).createSpec());
        }
        if (addTotalCount) {
            allColSpecs.add(new DataColumnSpecCreator("Total result count", LongCell.TYPE).createSpec());
        }
        return new DataTableSpec(allColSpecs.toArray(new DataColumnSpec[0]));
    }

    private Class<?> getResultType() {
        Class<? extends Searcher<?>> searcherClass = SEARCHERS.get(this.settingSearchEngine.getStringValue());
        return TypeResolver.resolveRawArgument(Searcher.class, searcherClass);
    }

    private Searcher<?> createSearcher(Class<? extends Searcher<?>> searcherClass, Configuration configuration) {
        Searcher searcher = SearcherFactory.createSearcher(searcherClass, (Configuration)configuration);
        if (searcher.isDeprecated()) {
            logger.warn((Object)("The searcher \"" + searcher.getName() + "\" (" + searcherClass.getName() + ") is deprecated and might be removed in future releases. The reason for this is ususally, that the search provider has ceased to support the API. Please consider using a different searcher, if you encounter any problems."));
        }
        return searcher;
    }

    private Configuration getConfiguration() {
        IPreferenceStore preferenceStore = PalladianPluginActivator.getDefault().getPreferenceStore();
        return new ApacheConfigurationAdapter(preferenceStore);
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingColumnName.getStringValue(), StringValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingColumnName.setStringValue(columnName);
        }
        return new DataTableSpec[]{this.createOutputSpec()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingColumnName.saveSettingsTo(settings);
        this.settingSearchEngine.saveSettingsTo(settings);
        this.settingNumResults.saveSettingsTo(settings);
        this.settingSearchLanguage.saveSettingsTo(settings);
        this.settingAppendTotalResultCount.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.loadSettingsFrom(settings);
        this.settingSearchEngine.loadSettingsFrom(settings);
        this.settingNumResults.loadSettingsFrom(settings);
        this.settingSearchLanguage.loadSettingsFrom(settings);
        try {
            this.settingAppendTotalResultCount.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingColumnName.validateSettings(settings);
        this.settingSearchEngine.validateSettings(settings);
        this.settingNumResults.validateSettings(settings);
        this.settingSearchLanguage.validateSettings(settings);
        try {
            this.settingAppendTotalResultCount.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

