/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search2;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.StringIconOption;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.retrieval.search2.WebSearcher2NodeSettings;
import ws.palladian.nodes.retrieval.search2.WebSearcherFactory;
import ws.palladian.retrieval.configuration.ConfigurationOption;
import ws.palladian.retrieval.configuration.StringConfigurationOption;
import ws.palladian.retrieval.resources.WebAudio;
import ws.palladian.retrieval.resources.WebImage;
import ws.palladian.retrieval.resources.WebVideo;
import ws.palladian.retrieval.search.Searcher;

public class WebSearcher2NodeDialog
extends DefaultNodeSettingsPane {
    private final WebSearcher2NodeSettings nodeSettings;
    private final SearcherConfigurationDialogComponent searchEngineOptionsComponent;

    protected WebSearcher2NodeDialog(boolean tableInput) {
        this.nodeSettings = new WebSearcher2NodeSettings(tableInput);
        if (tableInput) {
            this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.nodeSettings.queryColumnName, "Query", 0, new Class[]{StringValue.class}));
        } else {
            this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.query, "Query", true, 25));
        }
        StringIconOption[] searchers = (StringIconOption[])WebSearcherFactory.getSearchers().stream().map(SearcherOption::new).toArray(StringIconOption[]::new);
        DialogComponentStringSelection searcherSelection = new DialogComponentStringSelection(this.nodeSettings.searchEngine, "Search engine", searchers);
        JComboBox comboBox = (JComboBox)searcherSelection.getComponentPanel().getComponent(1);
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                SearcherOption stringIconOption = (SearcherOption)value;
                if (stringIconOption != null) {
                    this.setText(stringIconOption.getReadableName());
                    this.setIcon(stringIconOption.getIcon());
                }
                return component;
            }
        });
        this.addDialogComponent((DialogComponent)searcherSelection);
        this.searchEngineOptionsComponent = new SearcherConfigurationDialogComponent(this.nodeSettings.searcherConfig);
        this.addDialogComponent(this.searchEngineOptionsComponent);
        this.nodeSettings.searchEngine.addChangeListener(e -> this.updateSearchEngineButton());
        this.updateSearchEngineButton();
        List langs = Language.TEN_MOST_SPOKEN.stream().map(Language::getName).sorted().collect(Collectors.toList());
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.nodeSettings.language, "Language", langs));
        this.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.nodeSettings.numResults, "Number of results per query", (Number)10));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.appendTotalResultCount, "Append total result count column (not supported by every searcher)"));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.nodeSettings.outputColumnsPrefix, "Output columns prefix", false, 15));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.nodeSettings.appendRowKey, "Append a column with the input Row ID"));
    }

    private void updateSearchEngineButton() {
        try {
            Searcher.SearcherMetaInfo<?, ?> searcher = WebSearcherFactory.getSearcher(this.nodeSettings.searchEngine.getStringValue());
            this.searchEngineOptionsComponent.updateSearcher(searcher);
            this.nodeSettings.searcherConfig.clearKeyValues();
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }

    static String readableName(Searcher.SearcherMetaInfo<?, ?> searcher) {
        Class resultType = searcher.getResultType();
        String suffix = null;
        if (WebImage.class.isAssignableFrom(resultType)) {
            suffix = "Image";
        } else if (WebVideo.class.isAssignableFrom(resultType)) {
            suffix = "Video";
        } else if (WebAudio.class.isAssignableFrom(resultType)) {
            suffix = "Audio";
        }
        Object name = searcher.getSearcherName().replaceAll(" (Images?|Videos?|Audio)$", "");
        if (suffix != null) {
            name = (String)name + " (" + suffix + ")";
        }
        return name;
    }

    private static final class SearcherConfigurationDialogComponent
    extends DialogComponent {
        private static final String BUTTON_LABEL = "Search Engine Configuration \u2026";
        private final JButton button;
        private Searcher.SearcherMetaInfo<?, ?> searcher;

        public SearcherConfigurationDialogComponent(WebSearcher2NodeSettings.SearcherConfigSettingsModel model) {
            super((SettingsModel)model);
            this.getComponentPanel().setLayout(new FlowLayout());
            this.button = new JButton(BUTTON_LABEL);
            this.button.addActionListener(e -> {
                Map<String, String> dialogResult = this.openConfigDialog(model.getKeyValues());
                model.setKeyValues(dialogResult);
            });
            model.addChangeListener(e -> this.updateComponent());
            this.getComponentPanel().add(this.button);
        }

        protected void updateComponent() {
            boolean hasConfiguration = !this.searcher.getConfigurationOptions().isEmpty();
            this.button.setEnabled(hasConfiguration);
        }

        protected void validateSettingsBeforeSave() throws InvalidSettingsException {
            Map<String, String> keyValues = ((WebSearcher2NodeSettings.SearcherConfigSettingsModel)this.getModel()).getKeyValues();
            for (ConfigurationOption option : this.searcher.getConfigurationOptions()) {
                String value;
                if (!option.isRequired() || (value = keyValues.get(option.getKey())) != null && !value.isBlank()) continue;
                throw new InvalidSettingsException("The configuration \u201c" + option.getName() + "\u201d is missing. Please click the button \u201cSearch Engine Configuration \u2026\u201d and enter it there.");
            }
        }

        protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
        }

        protected void setEnabledComponents(boolean enabled) {
        }

        public void setToolTipText(String text) {
        }

        private Map<String, String> openConfigDialog(Map<String, String> inputConfig) {
            HashMap textFields = new HashMap();
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(e -> {
                JOptionPane optionPane = SearcherConfigurationDialogComponent.getOptionPane((JComponent)e.getSource());
                optionPane.setValue(cancelButton);
            });
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> {
                JOptionPane optionPane = SearcherConfigurationDialogComponent.getOptionPane((JComponent)e.getSource());
                optionPane.setValue(okButton);
            });
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            for (ConfigurationOption configOption : this.searcher.getConfigurationOptions()) {
                String string;
                c.gridx = 0;
                c.weightx = 0.0;
                c.fill = 2;
                Object labelText = configOption.getName();
                if (!configOption.isRequired()) {
                    labelText = (String)labelText + " (opt.)";
                }
                labelText = (String)labelText + "  ";
                panel.add((Component)new JLabel((String)labelText, 4), c);
                c.gridx = 1;
                JTextField textField = new JTextField(25);
                textField.getDocument().addDocumentListener(e -> SearcherConfigurationDialogComponent.validateInput(okButton, textFields));
                if (configOption instanceof StringConfigurationOption) {
                    StringConfigurationOption stringOpt = (StringConfigurationOption)configOption;
                    string = (String)stringOpt.getDefaultValue();
                } else {
                    string = null;
                }
                String defaultValue = string;
                String initialValue = inputConfig.getOrDefault(configOption.getKey(), defaultValue);
                textField.setText(initialValue);
                panel.add((Component)textField, c);
                textFields.put(configOption, textField);
                ++c.gridy;
            }
            SearcherConfigurationDialogComponent.validateInput(okButton, textFields);
            int result = JOptionPane.showOptionDialog(this.getComponentPanel(), panel, "Configuration for \u201c" + this.searcher.getSearcherName() + "\u201d", 2, -1, null, new JButton[]{okButton, cancelButton}, okButton);
            if (result == 0) {
                HashMap<String, String> resultConfig = new HashMap<String, String>();
                textFields.forEach((k, v) -> {
                    String string = resultConfig.put(k.getKey(), SearcherConfigurationDialogComponent.normalizeString(v));
                });
                return resultConfig;
            }
            return inputConfig;
        }

        private static String normalizeString(JTextField v) {
            String text = v.getText().strip();
            return text.isBlank() ? null : text;
        }

        private static void validateInput(JButton okButton, Map<ConfigurationOption<?>, JTextField> textFields) {
            boolean valid = true;
            for (Map.Entry<ConfigurationOption<?>, JTextField> textField : textFields.entrySet()) {
                if (!textField.getKey().isRequired() || !textField.getValue().getText().isBlank()) continue;
                valid = false;
                break;
            }
            okButton.setEnabled(valid);
        }

        private static JOptionPane getOptionPane(JComponent parent) {
            JOptionPane pane = null;
            pane = !(parent instanceof JOptionPane) ? SearcherConfigurationDialogComponent.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
            return pane;
        }

        public void updateSearcher(Searcher.SearcherMetaInfo<?, ?> searcher) {
            this.searcher = searcher;
            this.updateComponent();
        }
    }

    private static final class SearcherOption
    implements StringIconOption {
        private final Searcher.SearcherMetaInfo<?, ?> searcherInfo;

        SearcherOption(Searcher.SearcherMetaInfo<?, ?> searcherInfo) {
            this.searcherInfo = searcherInfo;
        }

        public String getText() {
            return this.searcherInfo.getSearcherId();
        }

        public Icon getIcon() {
            return WebSearcherFactory.getIcon(this.searcherInfo.getSearcherId());
        }

        private String getReadableName() {
            return WebSearcher2NodeDialog.readableName(this.searcherInfo);
        }
    }
}

