/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search2;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.xmlbeans.XmlException;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ConfigurableNodeFactory;
import org.knime.core.node.NodeDescription;
import org.knime.core.node.NodeDescription41Proxy;
import org.knime.core.node.NodeDialogPane;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeView;
import org.knime.core.node.context.NodeCreationConfiguration;
import org.knime.core.node.context.ports.PortsConfiguration;
import org.knime.core.node.port.PortType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ws.palladian.nodes.XPathUtils;
import ws.palladian.nodes.retrieval.search2.WebSearcher2NodeDialog;
import ws.palladian.nodes.retrieval.search2.WebSearcher2NodeModel;
import ws.palladian.nodes.retrieval.search2.WebSearcherFactory;
import ws.palladian.retrieval.search.Searcher;

public class WebSearcher2NodeFactory
extends ConfigurableNodeFactory<WebSearcher2NodeModel> {
    protected WebSearcher2NodeModel createNodeModel(NodeCreationConfiguration creationConfig) {
        PortType[] inputPorts = ((PortsConfiguration)creationConfig.getPortConfig().get()).getInputPorts();
        return new WebSearcher2NodeModel(inputPorts);
    }

    public int getNrNodeViews() {
        return 0;
    }

    public NodeView<WebSearcher2NodeModel> createNodeView(int viewIndex, WebSearcher2NodeModel nodeModel) {
        return null;
    }

    public boolean hasDialog() {
        return true;
    }

    protected NodeDialogPane createNodeDialogPane(NodeCreationConfiguration creationConfig) {
        PortType[] inputPorts = ((PortsConfiguration)creationConfig.getPortConfig().get()).getInputPorts();
        return new WebSearcher2NodeDialog(inputPorts.length > 0);
    }

    protected Optional<ConfigurableNodeFactory.PortsConfigurationBuilder> createPortsConfigBuilder() {
        ConfigurableNodeFactory.PortsConfigurationBuilder builder = new ConfigurableNodeFactory.PortsConfigurationBuilder();
        builder.addOptionalInputPortGroup("Input", new PortType[]{BufferedDataTable.TYPE});
        builder.addFixedOutputPortGroup("Result", new PortType[]{BufferedDataTable.TYPE});
        return Optional.of(builder);
    }

    protected NodeDescription createNodeDescription() throws SAXException, IOException, XmlException {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + ".xml");
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            DocumentBuilder parser = fac.newDocumentBuilder();
            Document document = parser.parse(inputStream);
            WebSearcher2NodeFactory.augmentXmlDescription(document.getDocumentElement());
            return new NodeDescription41Proxy(document);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void augmentXmlDescription(Element xmlDescription) throws SAXException, IOException {
        Document d = xmlDescription.getOwnerDocument();
        Node placeholder = (Node)XPathUtils.xPath(d, "//*[normalize-space() = 'PLACEHOLDER']", XPathConstants.NODE);
        if (placeholder == null) {
            NodeLogger.getLogger(WebSearcher2NodeModel.class).coding((Object)"PLACEHOLDER element is missing -- cannot insert dynamic parts into description.");
            return;
        }
        List<Searcher.SearcherMetaInfo<?, ?>> searchers = WebSearcherFactory.getSearchers();
        if (!searchers.isEmpty()) {
            Element table = d.createElement("table");
            Element trHeader = d.createElement("tr");
            Element thSearchEngine = d.createElement("th");
            thSearchEngine.appendChild(d.createTextNode("Search engine"));
            trHeader.appendChild(thSearchEngine);
            Element thDescription = d.createElement("th");
            thDescription.appendChild(d.createTextNode("Description"));
            trHeader.appendChild(thDescription);
            Element thDocs = d.createElement("th");
            thDocs.appendChild(d.createTextNode("API docs"));
            trHeader.appendChild(thDocs);
            table.appendChild(trHeader);
            for (Searcher.SearcherMetaInfo<?, ?> searcher : searchers) {
                Element tr = d.createElement("tr");
                Element tdName = d.createElement("th");
                tdName.appendChild(d.createTextNode(WebSearcher2NodeDialog.readableName(searcher)));
                tr.appendChild(tdName);
                Node tdDescription = d.createElement("td");
                if (searcher.getSearcherDescription() != null) {
                    try {
                        Node element = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader("<td>" + searcher.getSearcherDescription() + "</td>"))).getFirstChild();
                        tdDescription = d.importNode(element, true);
                    }
                    catch (ParserConfigurationException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (SAXException sAXException) {
                        NodeLogger.getLogger(WebSearcher2NodeModel.class).coding((Object)("Invalid HTML structure in description for " + searcher.getSearcherId() + ": " + searcher.getSearcherDescription()));
                    }
                }
                tr.appendChild(tdDescription);
                Element tdDocs = d.createElement("td");
                if (searcher.getSearcherDocumentationUrl() != null) {
                    Element a = d.createElement("a");
                    a.setAttribute("href", searcher.getSearcherDocumentationUrl());
                    a.appendChild(d.createTextNode("Link"));
                    tdDocs.appendChild(a);
                }
                tr.appendChild(tdDocs);
                table.appendChild(tr);
            }
            placeholder.getParentNode().insertBefore(table, placeholder);
        }
        placeholder.getParentNode().removeChild(placeholder);
    }
}

