/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.search2;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.SetCell;
import org.knime.core.data.container.DataContainer;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortType;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.search2.WebSearcher2NodeSettings;
import ws.palladian.nodes.retrieval.search2.WebSearcherFactory;
import ws.palladian.retrieval.resources.WebAudio;
import ws.palladian.retrieval.resources.WebContent;
import ws.palladian.retrieval.resources.WebImage;
import ws.palladian.retrieval.resources.WebVideo;
import ws.palladian.retrieval.search.MultifacetQuery;
import ws.palladian.retrieval.search.SearchResults;
import ws.palladian.retrieval.search.Searcher;

public class WebSearcher2NodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(WebSearcher2NodeModel.class);
    private static final String DUMMY_INPUT_COLUMN = "query";
    private final WebSearcher2NodeSettings nodeSettings;

    protected WebSearcher2NodeModel(PortType[] inputPorts) {
        super(inputPorts, new PortType[]{BufferedDataTable.TYPE});
        this.nodeSettings = new WebSearcher2NodeSettings(inputPorts.length > 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        Searcher.SearcherMetaInfo<?, ?> searcherMeta = WebSearcherFactory.getSearcher(this.nodeSettings.searchEngine.getStringValue());
        if (searcherMeta.isDeprecated()) {
            LOGGER.warn((Object)("The searcher \u201c" + searcherMeta.getSearcherName() + "\u201d (" + searcherMeta.getSearcherId() + ") is deprecated and might be removed in future releases. The reason for this is ususally, that the search provider has ceased to support the API. Please consider using a different searcher, if you encounter any problems."));
        }
        Map<String, String> searcherConfigSettings = this.nodeSettings.searcherConfig.getKeyValues();
        HashMap searcherConfig = new HashMap();
        searcherMeta.getConfigurationOptions().forEach(o -> searcherConfig.put(o, searcherConfigSettings.get(o.getKey())));
        Searcher searcher = searcherMeta.create(searcherConfig);
        Language language = Language.getByName((String)this.nodeSettings.language.getStringValue());
        boolean tableConnected = this.getNrInPorts() == 1;
        BufferedDataTable inputTable = tableConnected ? inData[0] : this.createDummyTable(this.nodeSettings.query.getStringValue());
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec(), searcherMeta);
        BufferedDataContainer buf = exec.createDataContainer(outputSpec);
        long inRowCount = tableConnected ? inData[0].size() : 1L;
        long inRowIndex = 0L;
        long outRowIndex = 0L;
        String inputColName = tableConnected ? this.nodeSettings.queryColumnName.getStringValue() : DUMMY_INPUT_COLUMN;
        int queryColumnIndex = inputTable.getDataTableSpec().findColumnIndex(inputColName);
        if (queryColumnIndex < 0) {
            throw new IllegalArgumentException("Invalid settings for input column (" + queryColumnIndex + "). Please (re)configure the node correctly.");
        }
        for (DataRow inRow : inputTable) {
            ++inRowIndex;
            DataCell cell = inRow.getCell(queryColumnIndex);
            if (cell.isMissing()) {
                int numAppendedCols = outputSpec.getNumColumns() - inData[0].getSpec().getNumColumns();
                DataCell[] missingCells = (DataCell[])Collections.nCopies(numAppendedCols, DataType.getMissingCell()).toArray(DataCell[]::new);
                buf.addRowToTable((DataRow)new AppendedColumnRow(inRow, missingCells));
                ++outRowIndex;
                exec.setProgress((double)inRowIndex / (double)inRowCount);
                continue;
            }
            String query = ((StringValue)cell).getStringValue();
            LOGGER.debugWithFormat("searching: %s - language: %s - results: %s", new Object[]{query, language, this.nodeSettings.numResults.getIntValue()});
            MultifacetQuery.Builder queryBuilder = new MultifacetQuery.Builder();
            queryBuilder.setText(query);
            queryBuilder.setResultCount(this.nodeSettings.numResults.getIntValue());
            queryBuilder.setLanguage(language);
            SearchResults webResults = searcher.search(queryBuilder.create());
            for (WebContent webResult : webResults) {
                RowKey key = RowKey.createRowKey((long)outRowIndex);
                ++outRowIndex;
                ArrayList<Object> cells = new ArrayList<Object>();
                if (this.nodeSettings.appendRowKey.getBooleanValue()) {
                    cells.add(new StringCell(inRow.getKey().toString()));
                }
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getTitle()));
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getSummary()));
                cells.add(PalladianKnimeHelper.createStringCell(webResult.getUrl()));
                if (webResult.getPublished() != null) {
                    cells.add(LocalDateTimeCellFactory.create((LocalDateTime)webResult.getPublished().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()));
                } else {
                    cells.add(DataType.getMissingCell());
                }
                if (webResult.getTags() != null) {
                    List tags = webResult.getTags().stream().map(StringCell::new).collect(Collectors.toList());
                    cells.add(CollectionCellFactory.createSetCell(tags));
                } else {
                    cells.add(DataType.getMissingCell());
                }
                if (webResult.getCoordinate() != null) {
                    cells.add(new GeoCoordinateCell(webResult.getCoordinate()));
                } else {
                    cells.add(DataType.getMissingCell());
                }
                if (webResult instanceof WebImage) {
                    WebImage webImage = (WebImage)webResult;
                    cells.add(PalladianKnimeHelper.createStringCell(webImage.getImageUrl()));
                    cells.add(PalladianKnimeHelper.createStringCell(webImage.getThumbnailUrl()));
                    cells.add(webImage.getWidth() != -1 ? new IntCell(webImage.getWidth()) : DataType.getMissingCell());
                    cells.add(webImage.getHeight() != -1 ? new IntCell(webImage.getHeight()) : DataType.getMissingCell());
                    cells.add(webImage.getSize() != -1 ? new IntCell(webImage.getSize()) : DataType.getMissingCell());
                }
                if (webResult instanceof WebVideo) {
                    WebVideo webVideo = (WebVideo)webResult;
                    cells.add(PalladianKnimeHelper.createStringCell(webVideo.getVideoUrl()));
                    cells.add(PalladianKnimeHelper.createStringCell(webVideo.getThumbnailUrl()));
                    cells.add(PalladianKnimeHelper.createIntCell(webVideo.getDuration()));
                }
                if (webResult instanceof WebAudio) {
                    WebAudio webAudio = (WebAudio)webResult;
                    cells.add(PalladianKnimeHelper.createStringCell(webAudio.getAudioUrl()));
                    cells.add(PalladianKnimeHelper.createIntCell(webAudio.getDuration()));
                }
                if (this.nodeSettings.appendTotalResultCount.getBooleanValue()) {
                    Long totalResults = webResults.getTotalResultCount();
                    cells.add(PalladianKnimeHelper.createLongCell(totalResults));
                }
                AppendedColumnRow outRow = new AppendedColumnRow(key, inRow, (DataCell[])cells.toArray(DataCell[]::new));
                buf.addRowToTable((DataRow)outRow);
            }
            exec.checkCanceled();
            int numResults = webResults.getResultList().size();
            exec.setProgress((double)inRowIndex / (double)inRowCount, "Received " + numResults + " results for \u201c" + query + "\u201d");
        }
        buf.close();
        BufferedDataTable outTable = buf.getTable();
        return new BufferedDataTable[]{outTable};
    }

    private DataTable createDummyTable(String query) {
        DataTableSpec spec = new DataTableSpecCreator().addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(DUMMY_INPUT_COLUMN, StringCell.TYPE).createSpec()}).createSpec();
        DataContainer container = new DataContainer(spec);
        StringCell cell = new StringCell(query);
        container.addRowToTable((DataRow)new DefaultRow(RowKey.createRowKey((long)0L), new DataCell[]{cell}));
        container.close();
        return container.getTable();
    }

    private DataTableSpec createOutputSpec(DataTableSpec inSpec, Searcher.SearcherMetaInfo<?, ?> searcherMeta) throws InvalidSettingsException {
        Class searchResultType = searcherMeta.getResultType();
        String prefix = this.nodeSettings.outputColumnsPrefix.getStringValue();
        DataTableSpecCreator spec = new DataTableSpecCreator(inSpec);
        if (this.nodeSettings.appendRowKey.getBooleanValue()) {
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Input Row ID", StringCell.TYPE).createSpec()});
        }
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Title", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Summary", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "URL", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Date", LocalDateTimeCellFactory.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Tags", SetCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Coordinate", GeoCoordinateCell.TYPE).createSpec()});
        if (WebImage.class.isAssignableFrom(searchResultType)) {
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Image URL", StringCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Thumbnail URL", StringCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Width", IntCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Height", IntCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Size", IntCell.TYPE).createSpec()});
        }
        if (WebVideo.class.isAssignableFrom(searchResultType)) {
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Video URL", StringCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Thumbnail URL", StringCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Duration", IntCell.TYPE).createSpec()});
        }
        if (WebAudio.class.isAssignableFrom(searchResultType)) {
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Audio URL", StringCell.TYPE).createSpec()});
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Duration", IntCell.TYPE).createSpec()});
        }
        if (this.nodeSettings.appendTotalResultCount.getBooleanValue()) {
            spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(prefix + "Total result count", LongCell.TYPE).createSpec()});
        }
        return spec.createSpec();
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec;
        boolean tableConnected;
        Searcher.SearcherMetaInfo<?, ?> searcherMeta = WebSearcherFactory.getSearcher(this.nodeSettings.searchEngine.getStringValue());
        boolean bl = tableConnected = this.getNrInPorts() == 1;
        if (tableConnected) {
            inSpec = inSpecs[0];
            if (StringUtils.notNullOrEmpty(this.nodeSettings.queryColumnName.getStringValue())) {
                PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.queryColumnName.getStringValue(), StringValue.class);
            } else {
                DataColumnSpec urlColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
                String columnName = urlColSpec.getName();
                this.setWarningMessage("Guessing URL input column: " + columnName);
                this.nodeSettings.queryColumnName.setStringValue(columnName);
            }
        } else {
            inSpec = this.createDummyTable(this.nodeSettings.query.getStringValue()).getDataTableSpec();
        }
        return new DataTableSpec[]{this.createOutputSpec(inSpec, searcherMeta)};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
        try {
            WebSearcherFactory.getSearcher(this.nodeSettings.searchEngine.getStringValue());
        }
        catch (InvalidSettingsException e) {
            this.setWarningMessage(e.getMessage());
        }
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

