/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils;

import java.io.IOException;
import java.util.Arrays;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.data.blob.BinaryObjectCellFactory;
import org.knime.core.data.blob.BinaryObjectDataCell;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelColumnFilter2;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import org.knime.core.node.util.filter.NameFilterConfiguration;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.RejectInputFilter;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.utils.FormEncodedHttpEntityCreatorNodeDialog;
import ws.palladian.retrieval.FormEncodedHttpEntity;
import ws.palladian.retrieval.HttpEntity;

public class FormEncodedHttpEntityCreatorNodeModel
extends SimpleStreamableFunctionNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(FormEncodedHttpEntityCreatorNodeModel.class);
    static final String CFGKEY_COLUMN_SELECTION = "inputColumns";
    private SettingsModelColumnFilter2 settingColumns;
    private BinaryObjectCellFactory binaryFactory;

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        this.binaryFactory = new BinaryObjectCellFactory(exec);
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec inSpec) throws InvalidSettingsException {
        NameFilterConfiguration.FilterResult filterResult = this.settingColumns.applyTo(inSpec);
        Object[] includedColumns = filterResult.getIncludes();
        logger.debug((Object)("Included headers: " + Arrays.toString(includedColumns)));
        if (includedColumns.length == 0) {
            this.setWarningMessage("No columns were selected; creating empty entities.");
        }
        int[] includedColumnIndexes = PalladianKnimeHelper.findColumnIndices(inSpec, (String[])includedColumns);
        DataColumnSpec colSpec = FormEncodedHttpEntityCreatorNodeModel.createAppendedColumnSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec, (String[])includedColumns, includedColumnIndexes){
            private final /* synthetic */ String[] val$includedColumns;
            private final /* synthetic */ int[] val$includedColumnIndexes;
            {
                this.val$includedColumns = stringArray;
                this.val$includedColumnIndexes = nArray;
                super($anonymous0);
            }

            public DataCell getCell(DataRow row) {
                FormEncodedHttpEntity.Builder entityBuilder = new FormEncodedHttpEntity.Builder();
                int i = 0;
                while (i < this.val$includedColumns.length) {
                    int colIdx = this.val$includedColumnIndexes[i];
                    DataCell cell = row.getCell(colIdx);
                    if (!cell.isMissing()) {
                        String key = this.val$includedColumns[i];
                        String value = ((StringValue)cell).getStringValue();
                        entityBuilder.addData(key, value);
                    }
                    ++i;
                }
                HttpEntity entity = entityBuilder.create();
                try {
                    return FormEncodedHttpEntityCreatorNodeModel.this.binaryFactory.create(entity.getInputStream());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Exception while trying to create binary cell", e);
                }
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)cellFactory);
        return rearranger;
    }

    private static DataColumnSpec createAppendedColumnSpec() {
        return new DataColumnSpecCreator("Entity", BinaryObjectDataCell.TYPE).createSpec();
    }

    protected void reset() {
        this.binaryFactory = null;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (this.settingColumns == null) {
            this.settingColumns = FormEncodedHttpEntityCreatorNodeDialog.createSettingsModelColumnSelection();
            this.settingColumns.loadDefaults(inSpec, RejectInputFilter.INSTANCE, true);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        if (this.settingColumns != null) {
            this.settingColumns.saveSettingsTo(settings);
        }
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        if (this.settingColumns == null) {
            this.settingColumns = FormEncodedHttpEntityCreatorNodeDialog.createSettingsModelColumnSelection();
        }
        this.settingColumns.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        SettingsModelColumnFilter2 filter = this.settingColumns == null ? FormEncodedHttpEntityCreatorNodeDialog.createSettingsModelColumnSelection() : this.settingColumns;
        filter.validateSettings(settings);
    }
}

