/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import ws.palladian.nodes.NodeSettings;

class MultipartEncodedHttpEntityCreateNodeSettings
implements Iterable<SettingsEntry>,
NodeSettings {
    private static final String KEY_FILE_NAMES = "fileNames";
    private static final String KEY_NAMES = "names";
    private static final String KEY_ENTITY_CONTENT_TYPES = "entityContentTypes";
    private static final String KEY_ENTITY_INPUT_COLUMNS = "entityInputColumns";
    private static final String KEY_ENTITY_OUTPUT_COLUMN_NAME = "entityOutputColumnName";
    private static final String DEFAULT_ENTITY_OUT_COL_NAME = "Entity";
    private static final String TEMPLATE_CONTENT_TYPE_OUT_COL_NAME = "%s (Content Type)";
    private List<SettingsEntry> settingEntries = Collections.emptyList();
    private String entityOutColName = "Entity";

    public MultipartEncodedHttpEntityCreateNodeSettings() {
    }

    public MultipartEncodedHttpEntityCreateNodeSettings(List<SettingsEntry> settingEntries, String entityOutColumnName) {
        this.settingEntries = settingEntries;
        this.entityOutColName = entityOutColumnName;
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        String[] entityInputColumns = new String[this.settingEntries.size()];
        String[] entityContentTypes = new String[this.settingEntries.size()];
        String[] names = new String[this.settingEntries.size()];
        String[] fileNames = new String[this.settingEntries.size()];
        int i = 0;
        while (i < this.settingEntries.size()) {
            SettingsEntry settingsEntry = this.settingEntries.get(i);
            entityInputColumns[i] = settingsEntry.entityInputColumn;
            entityContentTypes[i] = settingsEntry.entityContentType;
            names[i] = settingsEntry.name;
            fileNames[i] = MultipartEncodedHttpEntityCreateNodeSettings.stringOrNull(settingsEntry.fileName);
            ++i;
        }
        settings.addStringArray(KEY_ENTITY_INPUT_COLUMNS, entityInputColumns);
        settings.addStringArray(KEY_ENTITY_CONTENT_TYPES, entityContentTypes);
        settings.addStringArray(KEY_NAMES, names);
        settings.addStringArray(KEY_FILE_NAMES, fileNames);
        settings.addString(KEY_ENTITY_OUTPUT_COLUMN_NAME, this.entityOutColName);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        MultipartEncodedHttpEntityCreateNodeSettings temp = new MultipartEncodedHttpEntityCreateNodeSettings();
        temp.loadSettings(settings);
        temp.validateSettings();
    }

    private void validateSettings() throws InvalidSettingsException {
        for (SettingsEntry entry : this) {
            entry.validate();
        }
        if (MultipartEncodedHttpEntityCreateNodeSettings.nullOrEmpty(this.entityOutColName)) {
            throw new InvalidSettingsException("Name for entity column is missing");
        }
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.loadSettings(settings);
    }

    private void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingEntries = new ArrayList<SettingsEntry>();
        String[] entityInputColumns = settings.getStringArray(KEY_ENTITY_INPUT_COLUMNS);
        String[] entityContentTypes = settings.getStringArray(KEY_ENTITY_CONTENT_TYPES);
        String[] names = settings.getStringArray(KEY_NAMES);
        String[] fileNames = settings.getStringArray(KEY_FILE_NAMES);
        int i = 0;
        while (i < entityInputColumns.length) {
            String fileName = MultipartEncodedHttpEntityCreateNodeSettings.stringOrNull(fileNames[i]);
            this.settingEntries.add(new SettingsEntry(entityInputColumns[i], entityContentTypes[i], names[i], fileName));
            ++i;
        }
        this.entityOutColName = settings.getString(KEY_ENTITY_OUTPUT_COLUMN_NAME, DEFAULT_ENTITY_OUT_COL_NAME);
    }

    @Override
    public Iterator<SettingsEntry> iterator() {
        return Collections.unmodifiableList(this.settingEntries).iterator();
    }

    public String getEntityOutColName() {
        return this.entityOutColName;
    }

    public String getContentTypeOutColName() {
        return String.format(TEMPLATE_CONTENT_TYPE_OUT_COL_NAME, this.entityOutColName);
    }

    private static String stringOrNull(String value) {
        return MultipartEncodedHttpEntityCreateNodeSettings.nullOrEmpty(value) ? null : value;
    }

    private static boolean nullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static final class SettingsEntry {
        public final String entityInputColumn;
        public final String entityContentType;
        public final String name;
        public final String fileName;

        public SettingsEntry(String entityInputColumn, String entityContentType, String name, String fileName) {
            this.entityInputColumn = entityInputColumn;
            this.entityContentType = entityContentType;
            this.name = name;
            this.fileName = fileName;
        }

        private void validate() throws InvalidSettingsException {
            if (MultipartEncodedHttpEntityCreateNodeSettings.nullOrEmpty(this.entityInputColumn)) {
                throw new InvalidSettingsException("Input column is missing");
            }
            if (MultipartEncodedHttpEntityCreateNodeSettings.nullOrEmpty(this.entityContentType)) {
                throw new InvalidSettingsException("Content type is missing");
            }
            if (MultipartEncodedHttpEntityCreateNodeSettings.nullOrEmpty(this.name)) {
                throw new InvalidSettingsException("Name is missing");
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SettingsEntry [entityInputColumn=");
            builder.append(this.entityInputColumn);
            builder.append(", entityContentType=");
            builder.append(this.entityContentType);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", fileName=");
            builder.append(this.fileName);
            builder.append("]");
            return builder.toString();
        }
    }
}

