/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.oauth;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.util.filter.NameFilterConfiguration;
import ws.palladian.helper.UrlHelper;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.utils.oauth.OAuthSettings;
import ws.palladian.retrieval.HttpMethod;
import ws.palladian.retrieval.OAuthUtil;

@Deprecated
class OAuthNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(OAuthNodeModel.class);
    private final OAuthSettings oAuthSettings = new OAuthSettings();

    OAuthNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        DataTableSpec inSpec = inData[0].getSpec();
        NameFilterConfiguration.FilterResult filterResult = this.oAuthSettings.paramColumns.applyTo(inSpec);
        final int urlIdx = inSpec.findColumnIndex(this.oAuthSettings.urlColumn.getStringValue());
        final int methodIdx = inSpec.findColumnIndex(this.oAuthSettings.methodColumn.getStringValue());
        Object[] keys = filterResult.getIncludes();
        logger.debug((Object)("Included columns in OAuth request = " + Arrays.toString(keys)));
        int[] keyIdxs = PalladianKnimeHelper.findColumnIndices(inSpec, (String[])keys);
        OAuthUtil oAuthUtil = new OAuthUtil(this.oAuthSettings.createOAuthParams());
        SingleCellFactory cellFactory = new SingleCellFactory(OAuthNodeModel.createAppendedColSpec(), (String[])keys, keyIdxs, oAuthUtil){
            private final /* synthetic */ String[] val$keys;
            private final /* synthetic */ int[] val$keyIdxs;
            private final /* synthetic */ OAuthUtil val$oAuthUtil;
            {
                this.val$keys = stringArray;
                this.val$keyIdxs = nArray;
                this.val$oAuthUtil = oAuthUtil;
                super($anonymous0);
            }

            public DataCell getCell(DataRow row) {
                DataCell urlCell = row.getCell(urlIdx);
                if (urlCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                HttpMethod method = OAuthNodeModel.parseHttpMethod(row, methodIdx);
                String url = ((StringValue)urlCell).getStringValue();
                String baseUrl = UrlHelper.parseBaseUrl((String)url);
                List params = UrlHelper.parseParams((String)url);
                params.addAll(OAuthNodeModel.getAdditionalParams(this.val$keys, this.val$keyIdxs, row));
                String authorization = this.val$oAuthUtil.createAuthorization(method, baseUrl, params);
                return new StringCell(authorization);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(inSpec);
        rearranger.append((CellFactory)cellFactory);
        BufferedDataTable out = exec.createColumnRearrangeTable(inData[0], rearranger, (ExecutionMonitor)exec);
        return new BufferedDataTable[]{out};
    }

    private static List<Pair<String, String>> getAdditionalParams(String[] keys, int[] keyIdxs, DataRow row) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        int i = 0;
        while (i < keys.length) {
            DataCell paramCell = row.getCell(keyIdxs[i]);
            if (!paramCell.isMissing()) {
                String key = keys[i];
                String value = ((StringValue)paramCell).getStringValue();
                result.add((Pair<String, String>)Pair.of((Object)key, (Object)value));
            }
            ++i;
        }
        return result;
    }

    private static HttpMethod parseHttpMethod(DataRow row, int methodIdx) {
        if (methodIdx == -1) {
            logger.debug((Object)"No method column selected, assuming GET");
            return HttpMethod.GET;
        }
        DataCell methodCell = row.getCell(methodIdx);
        if (methodCell.isMissing()) {
            logger.debug((Object)"HTTP method missing, assuming GET");
            return HttpMethod.GET;
        }
        String methodString = ((StringValue)methodCell).getStringValue();
        try {
            return HttpMethod.valueOf((String)methodString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.debug((Object)("Invalid HTTP method '" + methodString + "', assuming GET"));
            return HttpMethod.GET;
        }
    }

    private static DataColumnSpec createAppendedColSpec() {
        return new DataColumnSpecCreator("Authorization", StringCell.TYPE).createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec urlColSpec = PalladianKnimeHelper.getColumn(inSpec, this.oAuthSettings.urlColumn.getStringValue(), StringValue.class);
        if (urlColSpec == null) {
            urlColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = urlColSpec.getName();
            this.setWarningMessage("Guessing URL input column: " + columnName);
            this.oAuthSettings.urlColumn.setStringValue(columnName);
        }
        this.oAuthSettings.configureParamSelection(inSpec);
        this.oAuthSettings.checkNecessaryInput();
        DataTableSpec outSpec = new DataTableSpecCreator(inSpec).addColumns(new DataColumnSpec[]{OAuthNodeModel.createAppendedColSpec()}).createSpec();
        return new DataTableSpec[]{outSpec};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.oAuthSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.oAuthSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.oAuthSettings.loadValidatedSettingsFrom(settings);
    }

    protected void reset() {
    }
}

