/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.utils.oauth;

import org.apache.commons.lang3.StringUtils;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelColumnFilter2;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.RejectInputFilter;
import ws.palladian.retrieval.OAuthParams;

@Deprecated
class OAuthSettings {
    private static final String CFGKEY_CONSUMER_KEY = "consumerKey";
    private static final String CFGKEY_CONSUMER_SECRET = "consumerSecret";
    private static final String CFGKEY_ACCESS_TOKEN = "accessToken";
    private static final String CFGKEY_ACCESS_TOKEN_SECRET = "accessTokenSecret";
    private static final String CFGKEY_URL_COLUMN = "urlColumn";
    private static final String CFGKEY_PARAM_COLUMN_SELECTION = "paramColumns";
    private static final String CFGKEY_METHOD_COLUMN = "methodColumn";
    final SettingsModelString consumerKey = new SettingsModelString("consumerKey", null);
    final SettingsModelString consumerSecret = new SettingsModelString("consumerSecret", null);
    final SettingsModelString accessToken = new SettingsModelString("accessToken", null);
    final SettingsModelString accessTokenSecret = new SettingsModelString("accessTokenSecret", null);
    final SettingsModelString urlColumn = new SettingsModelString("urlColumn", null);
    SettingsModelColumnFilter2 paramColumns;
    final SettingsModelString methodColumn = new SettingsModelString("methodColumn", null);

    OAuthSettings() {
    }

    static SettingsModelColumnFilter2 createParamSetting() {
        return new SettingsModelColumnFilter2(CFGKEY_PARAM_COLUMN_SELECTION, new Class[]{StringValue.class});
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.consumerKey.saveSettingsTo(settings);
        this.consumerSecret.saveSettingsTo(settings);
        this.accessToken.saveSettingsTo(settings);
        this.accessTokenSecret.saveSettingsTo(settings);
        this.urlColumn.saveSettingsTo(settings);
        if (this.paramColumns != null) {
            this.paramColumns.saveSettingsTo(settings);
        }
        this.methodColumn.saveSettingsTo(settings);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.consumerKey.validateSettings(settings);
        this.consumerSecret.validateSettings(settings);
        this.accessToken.validateSettings(settings);
        this.accessTokenSecret.validateSettings(settings);
        this.urlColumn.validateSettings(settings);
        SettingsModelColumnFilter2 filter = this.paramColumns == null ? OAuthSettings.createParamSetting() : this.paramColumns;
        filter.validateSettings(settings);
        this.methodColumn.validateSettings(settings);
    }

    public void checkNecessaryInput() throws InvalidSettingsException {
        if (StringUtils.isEmpty((CharSequence)this.consumerKey.getStringValue())) {
            throw new InvalidSettingsException("Please specify a consumer key.");
        }
        if (StringUtils.isEmpty((CharSequence)this.consumerSecret.getStringValue())) {
            throw new InvalidSettingsException("Please specify a consumer secret.");
        }
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.consumerKey.loadSettingsFrom(settings);
        this.consumerSecret.loadSettingsFrom(settings);
        this.accessToken.loadSettingsFrom(settings);
        this.accessTokenSecret.loadSettingsFrom(settings);
        this.urlColumn.loadSettingsFrom(settings);
        if (this.paramColumns == null) {
            this.paramColumns = OAuthSettings.createParamSetting();
        }
        this.paramColumns.loadSettingsFrom(settings);
        this.methodColumn.loadSettingsFrom(settings);
    }

    public OAuthParams createOAuthParams() {
        String accessTokenValue = StringUtils.trimToNull((String)this.accessToken.getStringValue());
        String accessTokenSecretValue = StringUtils.trimToNull((String)this.accessTokenSecret.getStringValue());
        return new OAuthParams(this.consumerKey.getStringValue(), this.consumerSecret.getStringValue(), accessTokenValue, accessTokenSecretValue);
    }

    public void configureParamSelection(DataTableSpec inSpec) {
        if (this.paramColumns == null) {
            this.paramColumns = OAuthSettings.createParamSetting();
            this.paramColumns.loadDefaults(inSpec, RejectInputFilter.INSTANCE, true);
        }
    }
}

