/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.retrieval.wiki;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.streamable.BufferedDataTableRowOutput;
import org.knime.core.node.streamable.PartitionInfo;
import org.knime.core.node.streamable.PortInput;
import org.knime.core.node.streamable.PortOutput;
import org.knime.core.node.streamable.RowOutput;
import org.knime.core.node.streamable.StreamableOperator;
import ws.palladian.helper.ProgressReporter;
import ws.palladian.helper.collection.CollectionHelper;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.KnimeProgressAdapter;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.helper.PalladianKnimeHelper;
import ws.palladian.nodes.retrieval.wiki.MediaWikiReaderNodeDialog;
import ws.palladian.retrieval.wiki.MediaWikiUtil;
import ws.palladian.retrieval.wiki.WikiLink;
import ws.palladian.retrieval.wiki.WikiPage;

class MediaWikiReaderNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(MediaWikiReaderNodeModel.class);
    public static final String CFGKEY_SETTING_DUMP_FILE = "dumpFile";
    private final SettingsModelString dumpFileSetting = MediaWikiReaderNodeDialog.createSettingDumpFile();

    protected MediaWikiReaderNodeModel() {
        super(0, 1);
    }

    public StreamableOperator createStreamableOperator(PartitionInfo partitionInfo, PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new StreamableOperator(){

            public void runFinal(PortInput[] inputs, PortOutput[] outputs, ExecutionContext exec) throws Exception {
                File dumpFile = new File(MediaWikiReaderNodeModel.this.dumpFileSetting.getStringValue());
                LOGGER.debug((Object)("Reading wiki dump file " + String.valueOf(dumpFile)));
                final RowOutput rowOutput = (RowOutput)outputs[0];
                final long[] rowIndex = new long[1];
                KnimeProgressAdapter progress = new KnimeProgressAdapter((ExecutionMonitor)exec);
                MediaWikiUtil.parseDump((File)dumpFile, (Consumer)new Consumer<WikiPage>(){

                    @Override
                    public void accept(WikiPage wikiPage) {
                        DataCell[] row = new DataCell[]{new IntCell(wikiPage.getId()), new IntCell(wikiPage.getNamespaceId()), PalladianKnimeHelper.createStringCell(wikiPage.getTitle()), PalladianKnimeHelper.createStringCell(wikiPage.getMarkup()), PalladianKnimeHelper.createStringCell(wikiPage.getCleanText()), BooleanCell.BooleanCellFactory.create((boolean)wikiPage.isRedirect()), PalladianKnimeHelper.createStringCell(wikiPage.getRedirectTitle()), MediaWikiReaderNodeModel.createListCell(wikiPage.getAlternativeTitles()), MediaWikiReaderNodeModel.createListCell(wikiPage.getCategories()), BooleanCell.BooleanCellFactory.create((boolean)wikiPage.isDisambiguation()), CollectionCellFactory.createListCell((Collection)CollectionHelper.convertList((Iterable)wikiPage.getLinks(), (Function)new Function<WikiLink, StringCell>(){

                            @Override
                            public StringCell apply(WikiLink link) {
                                return new StringCell(link.getDestination());
                            }
                        })), GeoCoordinateCell.create((GeoCoordinate)wikiPage.getCoordinate())};
                        try {
                            long l = rowIndex[0];
                            rowIndex[0] = l + 1L;
                            rowOutput.push((DataRow)new DefaultRow(RowKey.createRowKey((long)l), row));
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }, (ProgressReporter)progress);
                rowOutput.close();
            }
        };
    }

    private static DataCell createListCell(Iterable<String> strings) {
        return CollectionCellFactory.createListCell((Collection)CollectionHelper.convertList(strings, (Function)new Function<String, StringCell>(){

            @Override
            public StringCell apply(String string) {
                return new StringCell(string);
            }
        }));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        DataTableSpec spec = MediaWikiReaderNodeModel.createSpec();
        BufferedDataTableRowOutput output = new BufferedDataTableRowOutput(exec.createDataContainer(spec));
        this.createStreamableOperator(null, null).runFinal(null, new PortOutput[]{output}, exec);
        return new BufferedDataTable[]{output.getDataTable()};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{MediaWikiReaderNodeModel.createSpec()};
    }

    private static DataTableSpec createSpec() {
        DataTableSpecCreator spec = new DataTableSpecCreator();
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Page ID", IntCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Namespace ID", IntCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Title", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Markup", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Clean text", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Redirect", BooleanCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Redirect title", StringCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Alternative titles", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Categories", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Disambiguation", BooleanCell.TYPE).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Links", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
        spec.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator("Coordinate", GeoCoordinateCell.TYPE).createSpec()});
        return spec.createSpec();
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.dumpFileSetting.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.dumpFileSetting.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.dumpFileSetting.loadSettingsFrom(settings);
    }

    protected void reset() {
    }
}

