/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.regextractor;

import com.google.code.regexp.GroupInfo;
import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import de.philippkatz.regextractor.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;

public class RegExTractor {
    public static final String FULL_MATCH = "Full Match";
    private final Pattern pattern;
    private final List<String> groupNames;

    public RegExTractor(Pattern pattern) {
        this.pattern = Objects.requireNonNull(pattern);
        this.groupNames = RegExTractor.extractGroupNames(pattern);
    }

    public RegExTractor(String pattern) {
        this(pattern, 0);
    }

    public RegExTractor(String pattern, int flags) {
        this(Pattern.compile((String)Objects.requireNonNull(pattern), (int)flags));
    }

    public Result extract(CharSequence text) {
        Objects.requireNonNull(text);
        Matcher matcher = this.pattern.matcher(text);
        ArrayList<Match> matches = new ArrayList<Match>();
        int matchIdx = 0;
        while (matcher.find()) {
            ArrayList<Group> groups = new ArrayList<Group>();
            int groupIdx = 0;
            while (groupIdx <= matcher.groupCount()) {
                String value = matcher.group(groupIdx);
                int start = matcher.start(groupIdx);
                int end = matcher.end(groupIdx);
                groups.add(new Group(start, end, groupIdx, value));
                ++groupIdx;
            }
            matches.add(new Match(groups, matchIdx++));
        }
        return new Result(text.toString(), matches);
    }

    private static List<String> extractGroupNames(Pattern pattern) {
        int groupCount = pattern.matcher((CharSequence)"").groupCount();
        ArrayList<String> groupNames = new ArrayList<String>();
        groupNames.add(FULL_MATCH);
        int[] i = new int[1];
        while (i[0] < groupCount) {
            String groupName = pattern.groupInfo().entrySet().stream().filter(entry -> ((GroupInfo)((List)entry.getValue()).get(0)).groupIndex() == i[0]).map(Map.Entry::getKey).findFirst().orElse("Group " + (i[0] + 1));
            groupNames.add(groupName);
            i[0] = i[0] + 1;
        }
        return groupNames;
    }

    public List<String> getGroupNames() {
        return Collections.unmodifiableList(this.groupNames);
    }

    public int getGroupCount() {
        return this.groupNames.size();
    }

    public final class Group {
        private final int start;
        private final int end;
        private final int groupIdx;
        private final String value;

        Group(int start, int end, int groupIdx, String value) {
            this.start = start;
            this.end = end;
            this.groupIdx = groupIdx;
            this.value = value;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getValue() {
            return this.value;
        }

        public String getGroupName() {
            return RegExTractor.this.getGroupNames().get(this.groupIdx);
        }

        private void toHtml(StringBuilder appender) {
            appender.append("<tr>");
            Color color = Colors.getColorForIndex(this.groupIdx);
            String hexColor = Colors.toHex(color);
            appender.append(String.format("<td class='group-name' style='background-color: %s'>%s</td>", hexColor, this.getGroupName()));
            String span = this.value != null ? String.format("%s\u2013%s", this.start, this.end) : "";
            appender.append(String.format("<td class='group-span'>%s</td>", span));
            String mappedValue = Optional.ofNullable(this.value).map(StringEscapeUtils::escapeHtml4).orElse("");
            appender.append(String.format("<td class='value'>%s</td>", mappedValue));
            appender.append("</tr>");
        }
    }

    public static final class Match
    implements Iterable<Group> {
        private final List<Group> groups;
        private final int matchIdx;

        Match(List<Group> groups, int matchIdx) {
            this.groups = groups;
            this.matchIdx = matchIdx;
        }

        public List<Group> getGroups() {
            return Collections.unmodifiableList(this.groups);
        }

        public int groupCount() {
            return this.groups.size();
        }

        public Group group(int groupIdx) {
            return this.groups.get(groupIdx);
        }

        private void toHtml(StringBuilder appender) {
            appender.append(String.format("<tr><th colspan='3'>Match %s</th></tr>", this.matchIdx));
            this.groups.forEach(group -> group.toHtml(appender));
        }

        @Override
        public Iterator<Group> iterator() {
            return this.getGroups().iterator();
        }
    }

    public static final class Result
    implements Iterable<Match> {
        private final String text;
        private final List<Match> matches;

        Result(String text, List<Match> matches) {
            this.text = text;
            this.matches = matches;
        }

        public String getText() {
            return this.text;
        }

        public List<Match> getMatches() {
            return Collections.unmodifiableList(this.matches);
        }

        public String toHtml() {
            StringBuilder appender = new StringBuilder();
            appender.append("<html><body><table class='matches'>");
            this.matches.forEach(match -> match.toHtml(appender));
            appender.append("</table></body></html>");
            return appender.toString();
        }

        public int matchCount() {
            return this.matches.size();
        }

        public Match match(int matchIdx) {
            return this.matches.get(matchIdx);
        }

        @Override
        public Iterator<Match> iterator() {
            return this.getMatches().iterator();
        }
    }
}

