/*
 * Decompiled with CFR 0.152.
 */
package de.philippkatz.regextractor;

import de.philippkatz.regextractor.Colors;
import de.philippkatz.regextractor.MultiSelectBox;
import de.philippkatz.regextractor.PatternFlag;
import de.philippkatz.regextractor.RegExTractor;
import de.philippkatz.regextractor.RegexTemplate;
import de.philippkatz.regextractor.TimeoutCharSequence;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.commons.text.StringEscapeUtils;

public class RegExTractorUI
extends JPanel {
    private static final String TEXT = "some.email at gmail dot com\nasdf-FDSA at  ghjkl .  net\nthomas at yahoo .de\njosh@awesomecompanyname dot com\nmona.lisa [@] domain [dot] com\nstephen.spielberg [@] domain [.] com\n";
    private static final String REGEX = "(?<Username>[-\\w\\d\\.]+?)(?:\\s+at\\s+|\\s*@\\s*|\\s*(?:[\\[\\]@]){3}\\s*)(?<Domain>[-\\w\\d\\.]*?)\\s*(?:dot|\\.|(?:[\\[\\]dot\\.]){3,5})\\s*(?<TLD>\\w+)";
    private static final Font MONOSPACED_FONT = new Font("Monospaced", 0, 12);
    private static final String CARD_NAME_TEXT = "textInput";
    private static final String CARD_NAME_OVERLAY = "overlay";
    private final List<TemplateListener> templateListeners = new ArrayList<TemplateListener>();
    private final DefaultComboBoxModel<RegexTemplate> templateComboBoxModel = new DefaultComboBoxModel();
    private final JTextPane textInput;
    private final CardLayout textInputOrOverlayLayout;
    private final JLabel textOverlayLabel;
    private final JPanel textInputOrOverlay;
    private final JTextArea regexInput;
    private final JLabel previewLabel;
    private final JEditorPane results;
    private final MultiSelectBox<PatternFlag> flagBox;
    private final JComboBox<RegexTemplate> templateBox;
    private List<RegexTemplate> templates;
    private final AtomicReference<UpdateRegexArgs> updateArgsRef = new AtomicReference();
    private final AtomicInteger runningUpdateWorkers = new AtomicInteger(0);
    private long timeoutMs = -1L;

    public RegExTractorUI() {
        super(new BorderLayout());
        this.textInputOrOverlayLayout = new CardLayout();
        this.textInputOrOverlay = new JPanel(this.textInputOrOverlayLayout);
        JPanel textPanel = new JPanel(new BorderLayout(5, 5));
        textPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        textPanel.add((Component)new JLabel("Text"), "North");
        this.textInput = new JTextPane();
        this.textInput.getDocument().addDocumentListener(e -> this.updateRegex());
        this.textInput.setMinimumSize(new Dimension(450, 200));
        this.textInput.setFont(MONOSPACED_FONT);
        this.textInputOrOverlay.add(CARD_NAME_TEXT, new JScrollPane(this.textInput));
        this.textOverlayLabel = new JLabel("", 0);
        this.textOverlayLabel.setBorder(BorderFactory.createEtchedBorder());
        this.textInputOrOverlay.add(CARD_NAME_OVERLAY, this.textOverlayLabel);
        textPanel.add((Component)this.textInputOrOverlay, "Center");
        JPanel regexPanel = new JPanel(new BorderLayout(5, 5));
        regexPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel labelAndMenuPanel = new JPanel(new BorderLayout());
        labelAndMenuPanel.add((Component)new JLabel("Regex"), "West");
        List sortedFlags = Arrays.stream(PatternFlag.values()).sorted(Comparator.comparing(PatternFlag::toString)).collect(Collectors.toList());
        this.flagBox = new MultiSelectBox("Flags: 0", sortedFlags);
        this.flagBox.addSelectionChangeListener(e -> this.flagSelected());
        labelAndMenuPanel.add(this.flagBox, "East");
        regexPanel.add((Component)labelAndMenuPanel, "North");
        this.regexInput = new JTextArea();
        this.regexInput.getDocument().addDocumentListener(e -> this.updateRegex());
        this.regexInput.setLineWrap(true);
        this.regexInput.setMinimumSize(new Dimension(450, 50));
        this.regexInput.setFont(MONOSPACED_FONT);
        regexPanel.add((Component)new JScrollPane(this.regexInput), "Center");
        JPanel templatePanel = new JPanel(new BorderLayout());
        templatePanel.add((Component)new JLabel("Template  "), "West");
        this.templateBox = new JComboBox<RegexTemplate>(this.templateComboBoxModel);
        templatePanel.add(this.templateBox, "Center");
        JPanel templateButtonsPanel = new JPanel(new FlowLayout(0, 0, 0));
        JButton useTemplateButton = new JButton("Use");
        useTemplateButton.addActionListener(e -> {
            RegexTemplate template = (RegexTemplate)this.templateBox.getSelectedItem();
            this.setRegex(template.getRegex());
            this.setFlags(template.getFlags());
        });
        templateButtonsPanel.add(useTemplateButton);
        JButton saveTemplateButton = new JButton("Save \u2026");
        saveTemplateButton.addActionListener(e -> {
            String name = RegExTractorUI.showTemplateNameDialog(this);
            if (name == null) {
                return;
            }
            boolean cannotOverwrite = this.getTemplates().stream().anyMatch(template -> template.getName().equals(name) && template.isReadonly());
            if (cannotOverwrite) {
                JOptionPane.showMessageDialog(this, String.format("The existing template \u201c%s\u201d is readonly and \ncannot be overwritten. Please pick a different name", name), "Cannot Overwrite Template", 2);
                return;
            }
            RegexTemplate template2 = new RegexTemplate(name, this.getRegex(), this.getFlags());
            this.addTemplate(template2);
            this.fireListeners();
            this.templateBox.setSelectedItem(template2);
        });
        templateButtonsPanel.add(saveTemplateButton);
        JButton deleteTemplateButton = new JButton("Delete \u2026");
        deleteTemplateButton.addActionListener(e -> {
            RegexTemplate template = (RegexTemplate)this.templateBox.getSelectedItem();
            if (template.isReadonly()) {
                JOptionPane.showMessageDialog(this, String.format("The template \u201c%s\u201d is readonly and cannot be deleted.", template.getName()), "Cannot Delete Template", 2);
                return;
            }
            if (JOptionPane.showConfirmDialog(this, String.format("Delete template \u201c%s\u201d?", template.getName()), "Delete Template", 2, 2) == 0) {
                this.removeTemplate(template);
                this.fireListeners();
            }
        });
        templateButtonsPanel.add(deleteTemplateButton);
        templatePanel.add((Component)templateButtonsPanel, "East");
        regexPanel.add((Component)templatePanel, "South");
        JSplitPane splitPane = new JSplitPane(0, true, textPanel, regexPanel);
        splitPane.setResizeWeight(0.85);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setMinimumSize(new Dimension(450, 200));
        this.results = new JEditorPane();
        this.results.setEditable(false);
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = htmlEditorKit.getStyleSheet();
        styleSheet.addRule("body { font-family: sans-serif; font-size: 12pt; }");
        styleSheet.addRule(".matches { width: 100%; }");
        styleSheet.addRule(".matches td, th { padding: 3px }");
        styleSheet.addRule(".matches th { text-align: center; font-weight: bold; background-color: #eeeeee; border-bottom: 1px solid #aaaaaa; }");
        styleSheet.addRule(".matches .group-name { font-family: monospaced; white-space: nowrap; width: 5%; }");
        styleSheet.addRule(".matches .group-span { font-family: monospaced; color: #aaaaaa; white-space: nowrap; width: 5%; }");
        styleSheet.addRule(".matches .value { font-family: monospaced; width: 90%; }");
        styleSheet.addRule(".error, .warning { padding: 8px; }");
        styleSheet.addRule(".error { background-color: #FE5F6D; }");
        styleSheet.addRule(".warning { background-color: #FFC651; }");
        styleSheet.addRule(".error p, .warning p { margin: 0; }");
        styleSheet.addRule(".error pre { margin-top: 5px; font-size: 0.95em; }");
        this.results.setEditorKit(htmlEditorKit);
        this.results.setDocument(htmlEditorKit.createDefaultDocument());
        JPanel previewPanel = new JPanel(new BorderLayout(5, 5));
        previewPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.previewLabel = new JLabel("Matches");
        previewPanel.add((Component)this.previewLabel, "North");
        previewPanel.add((Component)new JScrollPane(this.results), "Center");
        previewPanel.setMinimumSize(new Dimension(0, 0));
        JSplitPane splitPane2 = new JSplitPane(1, true, splitPane, previewPanel){
            private boolean painted;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!this.painted) {
                    this.setDividerLocation(0.5);
                    this.painted = true;
                }
            }
        };
        splitPane2.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)splitPane2, "Center");
        this.updateRegex();
    }

    private static String showTemplateNameDialog(Component parentComponent) {
        String name;
        do {
            if ((name = JOptionPane.showInputDialog(parentComponent, "Please enter a name for the template. \nIf there\u2019s already a template with \nthis name, it\u2019ll get updated.\n\n", "Save Template", 3)) != null) continue;
            return null;
        } while (name.isEmpty());
        return name;
    }

    private void flagSelected() {
        String flagString = this.flagBox.getSelectedValues().stream().map(f -> f.characterFlag().map(c -> Character.toString(c.charValue())).orElse(f.toString())).collect(Collectors.joining(", "));
        this.flagBox.setText(String.format("Flags: %s", flagString.isEmpty() ? "none" : flagString));
        this.updateRegex();
    }

    private void updateRegex() {
        if (this.regexInput == null || this.results == null) {
            return;
        }
        this.previewLabel.setText("Updating preview \u2026");
        this.updateArgsRef.set(new UpdateRegexArgs(this.getRegex(), this.getFlags(), this.getText()));
        new SwingWorker<RegExTractor.Result, Void>(){
            private UpdateRegexArgs args;

            @Override
            protected RegExTractor.Result doInBackground() throws Exception {
                RegExTractorUI.this.runningUpdateWorkers.incrementAndGet();
                this.args = RegExTractorUI.this.updateArgsRef.getAndSet(null);
                if (this.args == null) {
                    return null;
                }
                if (this.args.regex == null || this.args.regex.isEmpty()) {
                    return null;
                }
                RegExTractor extractor = new RegExTractor(this.args.regex, this.args.flags);
                return extractor.extract(new TimeoutCharSequence(this.args.text, RegExTractorUI.this.timeoutMs));
            }

            @Override
            protected void done() {
                block13: {
                    try {
                        if (this.isCancelled()) {
                            RegExTractorUI.this.showMessage("warning", String.format("Executing the regex took too long and was timed out after %s ms to prevent freezing the application.", RegExTractorUI.this.timeoutMs));
                            return;
                        }
                        RegExTractor.Result result = (RegExTractor.Result)this.get();
                        if (result == null) {
                            RegExTractorUI.this.showMessage("warning", "Please enter a regex and a text to see the results here.");
                            return;
                        }
                        if (!this.args.regex.equals(RegExTractorUI.this.getRegex()) || this.args.flags != RegExTractorUI.this.getFlags() || !this.args.text.equals(RegExTractorUI.this.getText())) {
                            return;
                        }
                        try {
                            RegExTractorUI.this.textInput.getHighlighter().removeAllHighlights();
                            RegExTractorUI.this.showResult(result);
                        }
                        catch (InterruptedException | ExecutionException e) {
                            if (e.getCause() instanceof PatternSyntaxException) {
                                PatternSyntaxException patternSyntaxException = (PatternSyntaxException)e.getCause();
                                RegExTractorUI.this.results.setText(RegExTractorUI.createErrorMessage(patternSyntaxException));
                                RegExTractorUI.this.results.setCaretPosition(0);
                                break block13;
                            }
                            RegExTractorUI.this.showMessage("error", e.getMessage());
                        }
                    }
                    finally {
                        if (RegExTractorUI.this.runningUpdateWorkers.decrementAndGet() == 0) {
                            RegExTractorUI.this.previewLabel.setText("Matches");
                        }
                    }
                }
            }
        }.execute();
    }

    private void showResult(RegExTractor.Result result) {
        if (result.matchCount() == 0) {
            this.showMessage("warning", "No matches for the given text and regex.");
            return;
        }
        this.results.setText(result.toHtml());
        this.results.setCaretPosition(0);
        result.forEach(match -> {
            int groupIndex = match.groupCount() - 1;
            while (groupIndex >= 0) {
                RegExTractor.Group group = match.group(groupIndex);
                if (group.getEnd() - group.getStart() > 0) {
                    try {
                        Color color = Colors.getColorForIndex(groupIndex);
                        DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(color);
                        this.textInput.getHighlighter().addHighlight(group.getStart(), group.getEnd(), highlightPainter);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e);
                    }
                }
                --groupIndex;
            }
        });
    }

    private static String createErrorMessage(PatternSyntaxException e) {
        return String.format("<html><body><div class='error'><p>Error in Regular Expression: <strong>%s</strong></p><pre>%s</pre></div></body></html>", StringEscapeUtils.escapeHtml4((String)e.getDescription()), StringEscapeUtils.escapeHtml4((String)e.getMessage()));
    }

    private void showMessage(String cssClass, String msg) {
        String html = String.format("<html><body><div class='%s'><p>%s</p></div></body></html>", cssClass, StringEscapeUtils.escapeHtml4((String)msg));
        this.results.setText(html);
        this.results.setCaretPosition(0);
    }

    public String getRegex() {
        return this.regexInput.getText();
    }

    public void setRegex(String regex) {
        this.regexInput.setText(regex);
    }

    public int getFlags() {
        return PatternFlag.getCombinedFlag(this.flagBox.getSelectedValues());
    }

    public void setFlags(int value) {
        this.flagBox.setSelectedValues(PatternFlag.parseCombinedFlag(value));
    }

    public String getText() {
        return this.textInput.getText();
    }

    public void setText(String text) {
        this.textInput.setText(text);
    }

    public void setTextEditable(boolean editable) {
        this.textInput.setEditable(editable);
    }

    public List<RegexTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public void setTemplates(List<? extends RegexTemplate> templates) {
        Objects.requireNonNull(templates);
        this.templates = new ArrayList<RegexTemplate>(templates);
        this.updateComboboxModel(this.templates);
    }

    public void addTemplate(RegexTemplate template) {
        Objects.requireNonNull(template);
        this.templates.stream().filter(t -> t.getName().equals(template.getName())).findFirst().ifPresent(t -> {
            boolean bl = this.templates.remove(t);
        });
        this.templates.add(template);
        this.updateComboboxModel(this.templates);
    }

    public void removeTemplate(RegexTemplate template) {
        Objects.requireNonNull(template);
        this.templates.remove(template);
        this.updateComboboxModel(this.templates);
    }

    private void fireListeners() {
        this.templateListeners.forEach(TemplateListener::onTemplatesModified);
    }

    private void updateComboboxModel(List<RegexTemplate> items) {
        Collections.sort(this.templates, Comparator.comparing(RegexTemplate::getName));
        this.templateComboBoxModel.removeAllElements();
        items.forEach(template -> this.templateComboBoxModel.addElement((RegexTemplate)template));
    }

    public void addTemplateListener(TemplateListener templateListener) {
        Objects.requireNonNull(templateListener);
        this.templateListeners.add(templateListener);
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public void setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void showTextOverlay(String message) {
        this.textOverlayLabel.setText(message);
        this.textInputOrOverlayLayout.show(this.textInputOrOverlay, CARD_NAME_OVERLAY);
    }

    public void hideTextOverlay() {
        this.textInputOrOverlayLayout.show(this.textInputOrOverlay, CARD_NAME_TEXT);
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame("RegexMatcher");
            frame.setDefaultCloseOperation(3);
            RegExTractorUI ui = new RegExTractorUI();
            ui.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            ui.setText(TEXT);
            ui.setRegex(REGEX);
            ui.setFlags(PatternFlag.getCombinedFlag(PatternFlag.COMMENTS, PatternFlag.CASE_INSENSITIVE));
            ui.setText("");
            ui.showTextOverlay("<html><div style='text-align:center'><h2>Data not available</h2><p>To show the text, make sure that the upstream node<br>has executed and reopen the dialog. Alternatively, go<br>to the KNIME preferences \u2192 \u201cKNIME GUI\u201d and set the option<br>\u201cExecute upstream nodes when needed\u201d to \u201cAlways\u201d.</p></div></html>");
            ArrayList<RegexTemplate> templates = new ArrayList<RegexTemplate>();
            templates.add(new RegexTemplate("E-Mail", REGEX, PatternFlag.getCombinedFlag(PatternFlag.COMMENTS, PatternFlag.CASE_INSENSITIVE), true));
            ui.setTemplates(templates);
            ui.addTemplateListener(() -> System.out.println("Modified templates"));
            frame.getContentPane().add(ui);
            frame.setSize(1000, 600);
            frame.setVisible(true);
        });
    }

    public static interface TemplateListener {
        public void onTemplatesModified();
    }

    private static final class UpdateRegexArgs {
        final String regex;
        final int flags;
        final String text;

        UpdateRegexArgs(String regex, int flags, String text) {
            this.regex = regex;
            this.flags = flags;
            this.text = text;
        }
    }
}

