/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes;

import java.util.Iterator;
import java.util.Objects;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultCellIterator;

public class RemovedColumnRow
implements DataRow {
    private final DataRow baseRow;
    private final int removeIndex;

    public RemovedColumnRow(DataRow baseRow, int removeIndex) {
        Objects.requireNonNull(baseRow, "baseRow was null");
        if (removeIndex < 0) {
            throw new IllegalArgumentException("removeIndex must be >= 0");
        }
        if (removeIndex >= baseRow.getNumCells()) {
            throw new IllegalArgumentException("removeIndex must be < baseRow.getNumCells()");
        }
        this.baseRow = baseRow;
        this.removeIndex = removeIndex;
    }

    public Iterator<DataCell> iterator() {
        return new DefaultCellIterator((DataRow)this);
    }

    public int getNumCells() {
        return this.baseRow.getNumCells() - 1;
    }

    public RowKey getKey() {
        return this.baseRow.getKey();
    }

    public DataCell getCell(int index) {
        if (index < 0 || index >= this.getNumCells()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range [0, " + (this.getNumCells() - 1) + "]");
        }
        if (index < this.removeIndex) {
            return this.baseRow.getCell(index);
        }
        return this.baseRow.getCell(index + 1);
    }
}

