/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.util.Arrays;
import java.util.List;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentButtonGroup;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.classification.text.FeatureSetting;
import ws.palladian.classification.text.FeatureSettingBuilder;
import ws.palladian.helper.constants.Language;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public class FeatureSettingsConfiguration
implements NodeSettings {
    private static final String CFGKEY_MIN_NGRAM_LENGTH = "settingMinNGramLength";
    private static final String CFGKEY_MAX_NGRAM_LENGTH = "settingMaxNGramLength";
    private static final String CFGKEY_NGRAM_TYPE = "settingNGramType";
    private static final String CFGKEY_MAX_TERMS = "settingMaxTerms";
    private static final String CFGKEY_CASE_SENSITIVE = "settingCaseSensitive";
    private static final String CFGKEY_PADDING = "settingPadding";
    private static final String CFGKEY_LANGUAGE = "language";
    private static final String CFGKEY_REMOVE_STOPWORDS = "removeStopwords";
    private static final String CFGKEY_STEM = "steam";
    private static final String CFGKEY_SKIP_GRAM = "skipGrams";
    private static final String CFGKEY_MIN_TERM_LENGTH = "settingMinTermLength";
    private static final String CFGKEY_MAX_TERM_LENGTH = "settingMaxTermLength";
    private static final String NGRAM_TYPE_CHARACTER = "Character";
    private static final String NGRAM_TYPE_WORD = "Word";
    static final List<String> NGRAM_TYPES = Arrays.asList("Character", "Word");
    static final String[] LANGUAGES = new String[]{Language.GERMAN.toString(), Language.ENGLISH.toString()};
    private static final int DEFAULT_MIN_NGRAM_LENGTH = 3;
    private static final int DEFAULT_MAX_NGRAM_LENGTH = 7;
    private static final int MAX_NGRAM_LENGTH = 20;
    private static final String DEFAULT_NGRAM_TYPE = "Character";
    private static final int DEFAULT_MAX_TERMS = 800;
    private static final boolean DEFAULT_CASE_SENSITIVE = false;
    private static final boolean DEFAULT_PADDING = false;
    private static final int DEFAULT_MIN_TERM_LENGTH = 3;
    private static final int DEFAULT_MAX_TERM_LENGTH = 20;
    private final SettingsModelIntegerBounded minNGramLength = FeatureSettingsConfiguration.createSettingsMinNGramLength();
    private final SettingsModelIntegerBounded maxNGramLength = FeatureSettingsConfiguration.createSettingsMaxNGramLength();
    private final SettingsModelString nGramType = FeatureSettingsConfiguration.createSettingsNGram();
    private final SettingsModelIntegerBounded maxTerms = FeatureSettingsConfiguration.createSettingsTermCount();
    private final SettingsModelBoolean caseSensitive = FeatureSettingsConfiguration.createSettingsCaseSensitive();
    private final SettingsModelBoolean padding = FeatureSettingsConfiguration.createSettingsPadding();
    private final SettingsModelString language = FeatureSettingsConfiguration.createSettingsLanguage();
    private final SettingsModelBoolean removeStopwords = FeatureSettingsConfiguration.createSettingsRemoveStopwords();
    private final SettingsModelBoolean stem = FeatureSettingsConfiguration.createSettingsStem();
    private final SettingsModelBoolean skipGrams = this.createSettingsSkipGram();
    private final SettingsModelIntegerBounded minTermLength = new SettingsModelIntegerBounded("settingMinTermLength", 3, 1, Integer.MAX_VALUE);
    private final SettingsModelIntegerBounded maxTermLength = new SettingsModelIntegerBounded("settingMaxTermLength", 20, 1, Integer.MAX_VALUE);

    private static SettingsModelIntegerBounded createSettingsMinNGramLength() {
        return new SettingsModelIntegerBounded(CFGKEY_MIN_NGRAM_LENGTH, 3, 1, 20);
    }

    private static SettingsModelIntegerBounded createSettingsMaxNGramLength() {
        return new SettingsModelIntegerBounded(CFGKEY_MAX_NGRAM_LENGTH, 7, 1, 20);
    }

    private static SettingsModelString createSettingsNGram() {
        return new SettingsModelString(CFGKEY_NGRAM_TYPE, "Character");
    }

    private static SettingsModelIntegerBounded createSettingsTermCount() {
        return new SettingsModelIntegerBounded(CFGKEY_MAX_TERMS, 800, 1, 10000);
    }

    private static SettingsModelBoolean createSettingsCaseSensitive() {
        return new SettingsModelBoolean(CFGKEY_CASE_SENSITIVE, false);
    }

    private static SettingsModelBoolean createSettingsPadding() {
        return new SettingsModelBoolean(CFGKEY_PADDING, false);
    }

    private static SettingsModelString createSettingsLanguage() {
        return new SettingsModelString(CFGKEY_LANGUAGE, Language.ENGLISH.toString());
    }

    private static SettingsModelBoolean createSettingsRemoveStopwords() {
        return new SettingsModelBoolean(CFGKEY_REMOVE_STOPWORDS, false);
    }

    private static SettingsModelBoolean createSettingsStem() {
        return new SettingsModelBoolean(CFGKEY_STEM, false);
    }

    private SettingsModelBoolean createSettingsSkipGram() {
        return new SettingsModelBoolean(CFGKEY_SKIP_GRAM, false);
    }

    public FeatureSettingsConfiguration() {
        this.minNGramLength.addChangeListener(e -> {
            if (this.minNGramLength.getIntValue() > this.maxNGramLength.getIntValue()) {
                this.maxNGramLength.setIntValue(this.minNGramLength.getIntValue());
            }
            this.enableSkipGrams();
        });
        this.maxNGramLength.addChangeListener(e -> {
            if (this.maxNGramLength.getIntValue() < this.minNGramLength.getIntValue()) {
                this.minNGramLength.setIntValue(this.maxNGramLength.getIntValue());
            }
            this.enableSkipGrams();
        });
        this.minTermLength.addChangeListener(e -> {
            if (this.minTermLength.getIntValue() > this.maxTermLength.getIntValue()) {
                this.maxTermLength.setIntValue(this.minTermLength.getIntValue());
            }
        });
        this.maxTermLength.addChangeListener(e -> {
            if (this.maxTermLength.getIntValue() < this.minTermLength.getIntValue()) {
                this.minTermLength.setIntValue(this.maxTermLength.getIntValue());
            }
        });
        this.enableBorderPadding();
        this.enableLanguageSpecificSettings();
        this.enableSkipGrams();
        this.enableTermLength();
        this.nGramType.addChangeListener(e -> {
            this.enableBorderPadding();
            this.enableLanguageSpecificSettings();
            this.enableSkipGrams();
            this.enableTermLength();
        });
    }

    private void enableBorderPadding() {
        boolean enabled = this.nGramType.getStringValue().equals("Character");
        this.padding.setEnabled(enabled);
        if (!enabled) {
            this.padding.setBooleanValue(false);
        }
    }

    private void enableLanguageSpecificSettings() {
        boolean enabled = this.nGramType.getStringValue().equals(NGRAM_TYPE_WORD);
        this.language.setEnabled(enabled);
        this.removeStopwords.setEnabled(enabled);
        this.stem.setEnabled(enabled);
    }

    private void enableSkipGrams() {
        boolean enabled = this.nGramType.getStringValue().equals(NGRAM_TYPE_WORD) && this.maxNGramLength.getIntValue() > 2;
        this.skipGrams.setEnabled(enabled);
        if (!enabled) {
            this.skipGrams.setBooleanValue(false);
        }
    }

    private void enableTermLength() {
        boolean enabled = this.nGramType.getStringValue().equals(NGRAM_TYPE_WORD);
        this.minTermLength.setEnabled(enabled);
        this.maxTermLength.setEnabled(enabled);
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        this.nGramType.saveSettingsTo(settings);
        this.maxNGramLength.saveSettingsTo(settings);
        this.minNGramLength.saveSettingsTo(settings);
        this.maxTerms.saveSettingsTo(settings);
        this.caseSensitive.saveSettingsTo(settings);
        this.padding.saveSettingsTo(settings);
        this.language.saveSettingsTo(settings);
        this.removeStopwords.saveSettingsTo(settings);
        this.stem.saveSettingsTo(settings);
        this.skipGrams.saveSettingsTo(settings);
        this.minTermLength.saveSettingsTo(settings);
        this.maxTermLength.saveSettingsTo(settings);
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nGramType.loadSettingsFrom(settings);
        this.maxNGramLength.loadSettingsFrom(settings);
        this.minNGramLength.loadSettingsFrom(settings);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.maxTerms);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.caseSensitive);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.padding);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.language);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.removeStopwords);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.stem);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.skipGrams);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.minTermLength);
        PalladianKnimeHelper.tryLoadValidatedSettings(settings, (SettingsModel)this.maxTermLength);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nGramType.validateSettings(settings);
        this.maxNGramLength.validateSettings(settings);
        this.minNGramLength.validateSettings(settings);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.maxTerms);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.caseSensitive);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.padding);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.language);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.removeStopwords);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.stem);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.skipGrams);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.minTermLength);
        PalladianKnimeHelper.tryValidateSettings(settings, (SettingsModel)this.maxTermLength);
    }

    public void createFeatureSettingConfig(DefaultNodeSettingsPane dialog) {
        dialog.addDialogComponent((DialogComponent)new DialogComponentButtonGroup(this.nGramType, false, "n-gram type", NGRAM_TYPES.toArray(new String[0])));
        dialog.setHorizontalPlacement(true);
        dialog.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.minNGramLength, "Min. n-gram length", (Number)1, 2));
        dialog.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.maxNGramLength, "Max. n-gram length", (Number)1, 2));
        dialog.setHorizontalPlacement(false);
        dialog.setHorizontalPlacement(true);
        dialog.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.minTermLength, "Min. term length", (Number)1, 3));
        dialog.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.maxTermLength, "Max. term length", (Number)1, 3));
        dialog.setHorizontalPlacement(false);
        dialog.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)this.maxTerms, "Max. term count", (Number)100, 5));
        dialog.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.caseSensitive, "Case sensitive"));
        dialog.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.padding, "Border padding"));
        dialog.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.skipGrams, "Create skip-grams"));
        dialog.createNewTab("Language-specific settings");
        dialog.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.language, "Language", LANGUAGES));
        dialog.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.removeStopwords, "Remove stopwords"));
        dialog.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.stem, "Stem"));
    }

    public FeatureSetting getFeatureSetting() {
        FeatureSettingBuilder builder;
        String nGramValue = this.nGramType.getStringValue();
        if ("Character".equals(nGramValue)) {
            builder = FeatureSettingBuilder.chars();
        } else if (NGRAM_TYPE_WORD.equals(nGramValue)) {
            builder = FeatureSettingBuilder.words();
        } else {
            throw new IllegalStateException("Unknown n-gram type: " + nGramValue);
        }
        builder.nGramLength(this.minNGramLength.getIntValue(), this.maxNGramLength.getIntValue());
        builder.maxTerms(this.maxTerms.getIntValue());
        if (this.caseSensitive.getBooleanValue()) {
            builder.caseSensitive();
        }
        if (nGramValue.equals("Character") && this.padding.getBooleanValue()) {
            builder.characterPadding();
        }
        if (nGramValue.equals(NGRAM_TYPE_WORD)) {
            if (this.language.getStringValue() != null && !this.language.getStringValue().isEmpty()) {
                builder.language(Language.getByName((String)this.language.getStringValue()));
            }
            if (this.removeStopwords.getBooleanValue()) {
                builder.removeStopwords();
            }
            if (this.stem.getBooleanValue()) {
                builder.stem();
            }
            if (this.skipGrams.getBooleanValue()) {
                builder.createSkipGrams();
            }
            builder.termLength(this.minTermLength.getIntValue(), this.maxTermLength.getIntValue());
        }
        return builder.create();
    }
}

