/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.knime.core.data.util.memory.MemoryAlert;
import org.knime.core.data.util.memory.MemoryAlertListener;
import org.knime.core.data.util.memory.MemoryAlertSystem;
import org.knime.core.node.KNIMEConstants;
import org.knime.core.node.NodeLogger;
import ws.palladian.classification.text.DictionaryModel;

@Deprecated
class FileBackedTextClassifierPortObjectCache {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(FileBackedTextClassifierPortObjectCache.class);
    private static final FileBackedTextClassifierPortObjectCache INSTANCE = new FileBackedTextClassifierPortObjectCache();
    private final ConcurrentMap<String, DictionaryModel> modelCache = new ConcurrentHashMap<String, DictionaryModel>();
    private final ConcurrentMap<File, Object> cleanup = new ConcurrentHashMap<File, Object>();

    public static FileBackedTextClassifierPortObjectCache getInstance() {
        return INSTANCE;
    }

    private FileBackedTextClassifierPortObjectCache() {
        MemoryAlertSystem.getInstance().addListener(new MemoryAlertListener(){

            protected boolean memoryAlert(MemoryAlert alert) {
                LOGGER.info((Object)("Clearing FileBackedTextClassifierPortObjectCache with " + FileBackedTextClassifierPortObjectCache.this.modelCache.size() + " entries."));
                FileBackedTextClassifierPortObjectCache.this.modelCache.clear();
                return false;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (File file : FileBackedTextClassifierPortObjectCache.this.cleanup.keySet()) {
                    file.delete();
                }
            }
        });
    }

    public DictionaryModel get(String identifier) {
        return this.modelCache.computeIfAbsent(identifier, t -> FileBackedTextClassifierPortObjectCache.deserializeFromFile(this.getTempFile(identifier)));
    }

    public void put(String identifier, DictionaryModel model) {
        File tempFile = this.getTempFile(identifier);
        FileBackedTextClassifierPortObjectCache.serializeToFile(model, tempFile);
        this.modelCache.putIfAbsent(identifier, model);
    }

    public File getTempFile(String identifier) {
        File tempFile = new File(KNIMEConstants.getKNIMETempDir() + "/dictionaryModel_" + identifier + ".ser");
        this.cleanup.put(tempFile, tempFile);
        return tempFile;
    }

    private static void serializeToFile(DictionaryModel model, File file) {
        try {
            LOGGER.info((Object)("Writing DictionaryModel to " + String.valueOf(file)));
            ObjectOutputStream stream = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(file)));
            stream.writeObject(model);
            stream.close();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static DictionaryModel deserializeFromFile(File file) {
        LOGGER.info((Object)("Reading DictionaryModel from " + String.valueOf(file)));
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ObjectInputStream objectInput = new ObjectInputStream(new GZIPInputStream(new FileInputStream(file)));){
                return (DictionaryModel)objectInput.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Could not deserialize the class, as it does not exist");
        }
    }
}

