/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeProgressMonitor;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.classification.text.ITextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierModelWriterNodeDialog;

public class TextClassifierModelWriterNodeModel
extends NodeModel {
    static final String CFGKEY_OUTPUT_FILE = "outputFile";
    static final String TEXT_CLASSIFIER_MODEL_FILE_EXTENSION = ".palladianDictionaryModel";
    private final SettingsModelString settingOutputFile = TextClassifierModelWriterNodeDialog.createSettingsFilePath();

    protected TextClassifierModelWriterNodeModel() {
        super(new PortType[]{ITextClassifierPortObject.TYPE}, new PortType[0]);
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        ITextClassifierPortObject portObject = (ITextClassifierPortObject)inData[0];
        DictionaryModel dictionaryModel = portObject.getModel();
        Throwable throwable = null;
        Object var6_7 = null;
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(new ProgressOutputStream(new FileOutputStream(this.settingOutputFile.getStringValue()), exec.getProgressMonitor())));){
            objectOutputStream.writeObject(dictionaryModel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new PortObject[0];
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingOutputFile.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingOutputFile.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingOutputFile.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    private static final class ProgressOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final NodeProgressMonitor monitor;
        private long progress;
        private long lastUpdate;

        ProgressOutputStream(OutputStream out, NodeProgressMonitor monitor) {
            this.out = out;
            this.monitor = monitor;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.progress(1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.progress(len);
        }

        private void progress(int length) throws IOException {
            try {
                this.monitor.checkCanceled();
            }
            catch (CanceledExecutionException e) {
                throw new IOException(e);
            }
            this.progress += (long)length;
            if (this.progress / 1024L != this.lastUpdate) {
                ++this.lastUpdate;
                this.monitor.setProgress(String.format("Wrote %s kB", this.progress / 1024L));
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

