/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.zip.ZipEntry;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortObjectZipInputStream;
import org.knime.core.node.port.PortObjectZipOutputStream;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.PortTypeRegistry;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.nodes.classification.text.AbstractTextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierPortObjectSpec;

@Deprecated
public class TextClassifierPortObject
extends AbstractTextClassifierPortObject {
    public static final PortType TYPE = PortTypeRegistry.getInstance().getPortType(TextClassifierPortObject.class);
    private static final String FILE_NAME = "textClassifier.ser";
    private final DictionaryModel model;

    public TextClassifierPortObject(TextClassifierPortObjectSpec spec, DictionaryModel model) {
        super(spec);
        this.model = model;
    }

    public String getSummary() {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
        return String.format("Dictionary: %s terms, %s categories, %s entries", format.format(this.model.getNumUniqTerms()), format.format(this.model.getNumCategories()), format.format(this.model.getNumEntries()));
    }

    @Override
    public DictionaryModel getModel() {
        return this.model;
    }

    public static class Serializer
    extends PortObject.PortObjectSerializer<TextClassifierPortObject> {
        public void savePortObject(TextClassifierPortObject portObject, PortObjectZipOutputStream out, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            out.putNextEntry(new ZipEntry(TextClassifierPortObject.FILE_NAME));
            ObjectOutputStream objectOutput = new ObjectOutputStream((OutputStream)out);
            objectOutput.writeObject(portObject.getModel());
            objectOutput.close();
        }

        public TextClassifierPortObject loadPortObject(PortObjectZipInputStream in, PortObjectSpec spec, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
            String name = in.getNextEntry().getName();
            if (!TextClassifierPortObject.FILE_NAME.equals(name)) {
                throw new IOException("ZIP entry has unexpected name: " + name + ", expected textClassifier.ser");
            }
            ObjectInputStream objectInput = new ObjectInputStream((InputStream)in);
            try {
                DictionaryModel model = (DictionaryModel)objectInput.readObject();
                return new TextClassifierPortObject((TextClassifierPortObjectSpec)spec, model);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Could not deserialize the class, as it does not exist");
            }
        }
    }
}

