/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text;

import java.util.Arrays;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.classification.text.BayesScorer;
import ws.palladian.classification.text.ExperimentalScorers;
import ws.palladian.classification.text.PalladianTextClassifier;

public class TextClassifierPredictorNodeSettings {
    public static final int CLASSIFIER_IN_PORT = 0;
    public static final int TEXT_IN_PORT = 1;
    private static final String CFGKEY_TEXT_COLUMN_NAME = "settingTextColumn";
    private static final String CFGKEY_CLASS_DIST = "settingClassDistribution";
    private static final String CFGKEY_SCORER = "settingScorer";
    private SettingsModelString inputColumn = TextClassifierPredictorNodeSettings.createSettingsTextColumn();
    private SettingsModelBoolean classDist = TextClassifierPredictorNodeSettings.createSettingsClassDist();
    private SettingsModelString scorer = TextClassifierPredictorNodeSettings.createSettingsScorer();

    static SettingsModelString createSettingsScorer() {
        return new SettingsModelString(CFGKEY_SCORER, ScorerSetting.PALLADIAN.label);
    }

    static SettingsModelBoolean createSettingsClassDist() {
        return new SettingsModelBoolean(CFGKEY_CLASS_DIST, false);
    }

    static SettingsModelString createSettingsTextColumn() {
        return new SettingsModelString(CFGKEY_TEXT_COLUMN_NAME, null);
    }

    public void saveSettingsTo(NodeSettingsWO settings) {
        this.inputColumn.saveSettingsTo(settings);
        this.classDist.saveSettingsTo(settings);
        this.scorer.saveSettingsTo(settings);
    }

    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.loadSettingsFrom(settings);
        this.classDist.loadSettingsFrom(settings);
        try {
            this.scorer.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            this.scorer.setStringValue(ScorerSetting.PALLADIAN.label);
        }
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumn.validateSettings(settings);
        this.classDist.validateSettings(settings);
        try {
            this.scorer.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {}
    }

    PalladianTextClassifier.Scorer createScorer() {
        return ScorerSetting.byLabel((String)this.scorer.getStringValue()).scorer;
    }

    public String getInputColumnName() {
        return this.inputColumn.getStringValue();
    }

    public void setInputColumnName(String inputColumn) {
        this.inputColumn.setStringValue(inputColumn);
    }

    public boolean isAppendClassDist() {
        return this.classDist.getBooleanValue();
    }

    public static enum ScorerSetting {
        PALLADIAN("Palladian", (PalladianTextClassifier.Scorer)new PalladianTextClassifier.DefaultScorer()),
        BAYES("Complementary Na\u00efve Bayes", (PalladianTextClassifier.Scorer)new BayesScorer(new BayesScorer.Options[]{BayesScorer.Options.LAPLACE, BayesScorer.Options.COMPLEMENT})),
        BAYES_F("Complementary Na\u00efve Bayes (frequencies)", (PalladianTextClassifier.Scorer)new BayesScorer(new BayesScorer.Options[]{BayesScorer.Options.LAPLACE, BayesScorer.Options.COMPLEMENT, BayesScorer.Options.FREQUENCIES})),
        BAYES_P("Complementary Na\u00efve Bayes (priors)", (PalladianTextClassifier.Scorer)new BayesScorer(new BayesScorer.Options[]{BayesScorer.Options.LAPLACE, BayesScorer.Options.COMPLEMENT, BayesScorer.Options.PRIORS})),
        BAYES_F_P("Complementary Na\u00efve Bayes (frequencies, priors)", (PalladianTextClassifier.Scorer)new BayesScorer(new BayesScorer.Options[]{BayesScorer.Options.LAPLACE, BayesScorer.Options.COMPLEMENT, BayesScorer.Options.FREQUENCIES, BayesScorer.Options.PRIORS})),
        K_L("Kullback-Leibler", (PalladianTextClassifier.Scorer)ExperimentalScorers.KLScorer.INSTANCE);

        private final String label;
        private final PalladianTextClassifier.Scorer scorer;

        private ScorerSetting(String label, PalladianTextClassifier.Scorer scorer) {
            this.label = label;
            this.scorer = scorer;
        }

        public static ScorerSetting byLabel(String label) {
            ScorerSetting[] scorerSettingArray = ScorerSetting.values();
            int n = scorerSettingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScorerSetting setting = scorerSettingArray[n2];
                if (setting.label.equals(label)) {
                    return setting;
                }
                ++n2;
            }
            throw new IllegalStateException("Unknown scorer: '" + label + "'.");
        }

        public static String[] labels() {
            return (String[])Arrays.stream(ScorerSetting.values()).map(s -> s.label).toArray(String[]::new);
        }
    }
}

