/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import org.knime.core.data.filestore.FileStore;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelDouble;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.classification.text.DictionaryTrieModel;
import ws.palladian.classification.text.PruningStrategies;
import ws.palladian.helper.functional.Predicates;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.classification.text.FileStoreTextClassifierPortObject;
import ws.palladian.nodes.classification.text.ITextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierPortObjectSpec;
import ws.palladian.nodes.classification.text.utils.TextClassifierModelPrunerNodeDialog;

public class TextClassifierModelPrunerNodeModel
extends NodeModel {
    static final String CFGKEY_MIN_TERM_COUNT = "minimumTermCount";
    static final int DEFAULT_MIN_TERM_COUNT = 1;
    static final String CFGKEY_MIN_INFORMATION_GAIN = "minimumInformationGain";
    static final double DEFAULT_MIN_INFORMATION_GAIN = 0.0;
    private final SettingsModelInteger settingMinTermCount = TextClassifierModelPrunerNodeDialog.createSettingsModelMinTermCount();
    private final SettingsModelDouble settingMinInformationGain = TextClassifierModelPrunerNodeDialog.createSettingsModelMinInformationGain();

    protected TextClassifierModelPrunerNodeModel() {
        super(new PortType[]{ITextClassifierPortObject.TYPE}, new PortType[]{ITextClassifierPortObject.TYPE});
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        double minInformationGain;
        PalladianPluginActivator.checkLicense();
        ITextClassifierPortObject portObject = (ITextClassifierPortObject)inData[0];
        DictionaryModel model = portObject.getModel();
        DictionaryTrieModel.Builder builder = new DictionaryTrieModel.Builder();
        builder.setName(model.getName());
        builder.setFeatureSetting(model.getFeatureSetting());
        builder.addDictionary(model);
        HashSet filters = new HashSet();
        int minTermCount = this.settingMinTermCount.getIntValue();
        if (minTermCount > 1) {
            filters.add(PruningStrategies.termCount((int)minTermCount));
        }
        if ((minInformationGain = this.settingMinInformationGain.getDoubleValue()) > 0.0) {
            filters.add(new PruningStrategies.InformationGainPruningStrategy(model, minInformationGain));
        }
        builder.setPruningStrategy(Predicates.and(filters));
        FileStore fileStore = exec.createFileStore(UUID.randomUUID().toString());
        return new PortObject[]{FileStoreTextClassifierPortObject.createPortObject((TextClassifierPortObjectSpec)portObject.getSpec(), builder.create(), fileStore)};
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[1];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingMinTermCount.saveSettingsTo(settings);
        this.settingMinInformationGain.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingMinTermCount.loadSettingsFrom(settings);
        this.settingMinInformationGain.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingMinTermCount.validateSettings(settings);
        this.settingMinInformationGain.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

