/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.classification.text.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import ws.palladian.classification.text.DictionaryModel;
import ws.palladian.core.Category;
import ws.palladian.core.CategoryEntries;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.classification.text.ITextClassifierPortObject;
import ws.palladian.nodes.classification.text.TextClassifierLearnerNodeModel;
import ws.palladian.nodes.classification.text.utils.TextClassifierModelToTableNodeDialog;

public class TextClassifierModelToTableNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(TextClassifierLearnerNodeModel.class);
    static final String CFGKEY_RELATIVE_COUNTS = "relativeCounts";
    private final SettingsModelBoolean settingRelativeCounts = TextClassifierModelToTableNodeDialog.createSettingsRelativeCounts();

    protected TextClassifierModelToTableNodeModel() {
        super(new PortType[]{ITextClassifierPortObject.TYPE}, new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE});
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        ITextClassifierPortObject portObject = (ITextClassifierPortObject)inData[0];
        DictionaryModel model = portObject.getModel();
        BufferedDataTable termsTable = this.createTermsTable(exec, model);
        BufferedDataTable categoryPriorsTable = this.createCategoryPriorsTable(exec, model);
        return new BufferedDataTable[]{termsTable, categoryPriorsTable};
    }

    private BufferedDataTable createCategoryPriorsTable(ExecutionContext exec, DictionaryModel model) throws CanceledExecutionException {
        boolean relativeCounts;
        DataColumnSpec[] colSpecs = new DataColumnSpec[]{new DataColumnSpecCreator("Category", StringCell.TYPE).createSpec(), (relativeCounts = this.settingRelativeCounts.getBooleanValue()) ? new DataColumnSpecCreator("probability", DoubleCell.TYPE).createSpec() : new DataColumnSpecCreator("count", LongCell.TYPE).createSpec()};
        DataTableSpec outputSpec = new DataTableSpec(colSpecs);
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        exec.setProgress("Creating category priors table");
        long rowIdx = 0L;
        for (Category category : model.getDocumentCounts()) {
            RowKey key = RowKey.createRowKey((long)rowIdx++);
            DataCell[] cells = new DataCell[]{new StringCell(category.getName()), relativeCounts ? new DoubleCell(category.getProbability()) : new LongCell((long)category.getCount())};
            container.addRowToTable((DataRow)new DefaultRow(key, cells));
            exec.checkCanceled();
        }
        container.close();
        return container.getTable();
    }

    private BufferedDataTable createTermsTable(ExecutionContext exec, DictionaryModel model) throws CanceledExecutionException {
        boolean relativeCounts = this.settingRelativeCounts.getBooleanValue();
        int numColumns = model.getCategories().size() + 2;
        Object[] allColSpecs = new DataColumnSpec[numColumns];
        allColSpecs[0] = new DataColumnSpecCreator("Token", StringCell.TYPE).createSpec();
        int idx = 1;
        for (String categoryName : model.getCategories()) {
            DataType type = relativeCounts ? DoubleCell.TYPE : LongCell.TYPE;
            allColSpecs[idx++] = new DataColumnSpecCreator(categoryName, type).createSpec();
        }
        allColSpecs[idx++] = new DataColumnSpecCreator("count", LongCell.TYPE).createSpec();
        logger.debug((Object)("Col spec = " + Arrays.toString(allColSpecs)));
        DataTableSpec outputSpec = new DataTableSpec((DataColumnSpec[])allColSpecs);
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        long rowIdx = 0L;
        for (DictionaryModel.DictionaryEntry dictionaryEntry : model) {
            CategoryEntries categoryEntries = dictionaryEntry.getCategoryEntries();
            RowKey key = RowKey.createRowKey((long)rowIdx++);
            DataCell[] cells = new DataCell[numColumns];
            String term = dictionaryEntry.getTerm();
            cells[0] = new StringCell(term);
            int colIdx = 1;
            for (String categoryName : model.getCategories()) {
                cells[colIdx++] = relativeCounts ? new DoubleCell(categoryEntries.getProbability(categoryName)) : new LongCell((long)categoryEntries.getCount(categoryName));
            }
            cells[colIdx++] = new LongCell((long)categoryEntries.getTotalCount());
            DefaultRow row = new DefaultRow(key, cells);
            container.addRowToTable((DataRow)row);
            exec.checkCanceled();
            exec.setProgress((double)rowIdx / (double)model.getNumTerms(), "Appended row for '" + term + "'.");
        }
        container.close();
        return container.getTable();
    }

    protected void reset() {
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[2];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingRelativeCounts.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingRelativeCounts.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingRelativeCounts.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

