/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.content2;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.content.PalladianContentExtractor;
import ws.palladian.extraction.content.ReadabilityContentExtractor;
import ws.palladian.extraction.content.WebPageContentExtractor;

class ContentExtractor2NodeSettings {
    private static final String CFGKEY_INPUT_COLUMN_NAME = "inputColumn";
    private static final String CFGKEY_EXTRACTOR_TYPE = "extractorType";
    private static final String CFGKEY_REMOVE_DOCUMENT_COLUMN = "removeDocumentColumn";
    private static final String CFGKEY_OUTPUT_COLUMN_PREFIX = "outputColumnPrefix";
    private static final ExtractionMethod DEFAULT_EXTRACTOR = ExtractionMethod.READABILITY;
    private final SettingsModelString settingExtractorType = new SettingsModelString("extractorType", DEFAULT_EXTRACTOR.toString());
    private final SettingsModelString settingInputColumn = new SettingsModelString("inputColumn", null);
    private final SettingsModelBoolean settingRemoveDocumentColumn = new SettingsModelBoolean("removeDocumentColumn", false);
    private final SettingsModelString settingOutputColumnPrefix = new SettingsModelString("outputColumnPrefix", "Extracted: ");

    ContentExtractor2NodeSettings() {
    }

    public WebPageContentExtractor createContentExtractor() {
        String extractionMethodLabel = this.settingExtractorType.getStringValue();
        ExtractionMethod extractionMethod = ExtractionMethod.getByLabel(extractionMethodLabel);
        return extractionMethod.supplier.get();
    }

    public void saveSettings(NodeSettingsWO settings) {
        this.settingExtractorType.saveSettingsTo(settings);
        this.settingInputColumn.saveSettingsTo(settings);
        this.settingRemoveDocumentColumn.saveSettingsTo(settings);
        this.settingOutputColumnPrefix.saveSettingsTo(settings);
    }

    public void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingExtractorType.loadSettingsFrom(settings);
        this.settingInputColumn.loadSettingsFrom(settings);
        this.settingRemoveDocumentColumn.loadSettingsFrom(settings);
        this.settingOutputColumnPrefix.loadSettingsFrom(settings);
    }

    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingExtractorType.validateSettings(settings);
        this.settingInputColumn.validateSettings(settings);
        this.settingRemoveDocumentColumn.validateSettings(settings);
        this.settingOutputColumnPrefix.validateSettings(settings);
    }

    public SettingsModelString getSettingInputColumn() {
        return this.settingInputColumn;
    }

    public SettingsModelString getSettingExtractorType() {
        return this.settingExtractorType;
    }

    public SettingsModelBoolean getSettingRemoveDocumentColumn() {
        return this.settingRemoveDocumentColumn;
    }

    public SettingsModelString getSettingOutputColumnPrefix() {
        return this.settingOutputColumnPrefix;
    }

    static enum ExtractionMethod {
        READABILITY("Readability", () -> new ReadabilityContentExtractor()),
        PALLADIAN("Palladian", () -> new PalladianContentExtractor());

        private final String label;
        private final Supplier<WebPageContentExtractor> supplier;

        private ExtractionMethod(String label, Supplier<WebPageContentExtractor> supplier) {
            this.label = label;
            this.supplier = supplier;
        }

        public String toString() {
            return this.label;
        }

        public static String[] labels() {
            return (String[])Arrays.stream(ExtractionMethod.values()).map(m -> m.toString()).toArray(String[]::new);
        }

        public static ExtractionMethod getByLabel(String label) {
            Objects.requireNonNull(label);
            return Arrays.stream(ExtractionMethod.values()).filter(m -> m.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not found: " + label));
        }
    }
}

