/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.date2;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.streamable.InputPortRole;
import org.knime.core.node.streamable.OutputPortRole;
import org.knime.core.node.streamable.PartitionInfo;
import org.knime.core.node.streamable.PortInput;
import org.knime.core.node.streamable.PortOutput;
import org.knime.core.node.streamable.RowInput;
import org.knime.core.node.streamable.RowOutput;
import org.knime.core.node.streamable.StreamableOperator;
import ws.palladian.helper.date.DateParser;
import ws.palladian.helper.date.ExtractedDate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.date2.DateExtractor2NodeSettings;
import ws.palladian.nodes.extraction.date2.MappingStrategy;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public class DateExtractor2NodeModel
extends NodeModel {
    private final DateExtractor2NodeSettings nodeSettings = new DateExtractor2NodeSettings();

    protected DateExtractor2NodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        DataTableSpec outputSpec = mappingStrategy.createSpec(inData[0].getSpec(), this.nodeSettings);
        BufferedDataContainer dataContainer = exec.createDataContainer(outputSpec);
        long inRowCount = inData[0].size();
        long inRowIndex = 0L;
        int inputColumnIndex = inData[0].getSpec().findColumnIndex(this.nodeSettings.getInputColumnName());
        for (DataRow inRow : inData[0]) {
            List extractedDates = Collections.emptyList();
            DataCell cell = inRow.getCell(inputColumnIndex);
            if (!cell.isMissing()) {
                String text = DateExtractor2NodeModel.getText(cell);
                extractedDates = DateParser.findDates((String)text);
            }
            List<DataRow> outRows = mappingStrategy.map(inRow, extractedDates, this.nodeSettings, inputColumnIndex);
            outRows.forEach(arg_0 -> ((BufferedDataContainer)dataContainer).addRowToTable(arg_0));
            exec.checkCanceled();
            exec.setProgress((double)inRowIndex++ / (double)inRowCount, "Date Extracted for " + inRowIndex);
        }
        dataContainer.close();
        BufferedDataTable outTable = dataContainer.getTable();
        return new BufferedDataTable[]{outTable};
    }

    static DataCell createDateAndTimeCell(ExtractedDate extractedDate) {
        if (extractedDate == null) {
            return DataType.getMissingCell();
        }
        int year = Math.max(0, extractedDate.get(1));
        int month = Math.max(1, extractedDate.get(2));
        int dayOfMonth = Math.max(1, extractedDate.get(3));
        int hourOfDay = Math.max(0, extractedDate.get(4));
        int minute = Math.max(0, extractedDate.get(5));
        int second = Math.max(0, extractedDate.get(6));
        LocalDateTime localDateTime = LocalDateTime.of(year, month, dayOfMonth, hourOfDay, minute, second);
        return LocalDateTimeCellFactory.create((LocalDateTime)localDateTime);
    }

    private static String getText(DataCell cell) {
        DataType cellType = cell.getType();
        if (!cellType.isCompatible(StringValue.class)) {
            throw new IllegalArgumentException("Column type incompatible: " + cellType.toString());
        }
        String text = ((StringValue)cell).getStringValue();
        return text;
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.getInputColumnName())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.getInputColumnName(), StringValue.class);
        } else {
            DataColumnSpec inColSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            this.setWarningMessage("Guessing input column: " + inColSpec.getName());
            this.nodeSettings.setInputColumnName(inColSpec.getName());
        }
        DataTableSpec spec = this.nodeSettings.getMappingStrategy().createSpec(inSpec, this.nodeSettings);
        return new DataTableSpec[]{spec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    public InputPortRole[] getInputPortRoles() {
        return new InputPortRole[]{InputPortRole.DISTRIBUTED_STREAMABLE};
    }

    public OutputPortRole[] getOutputPortRoles() {
        return new OutputPortRole[]{OutputPortRole.DISTRIBUTED};
    }

    public StreamableOperator createStreamableOperator(PartitionInfo partitionInfo, PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        PalladianPluginActivator.checkLicense();
        final MappingStrategy mappingStrategy = this.nodeSettings.getMappingStrategy();
        final int inputColumnIndex = ((DataTableSpec)inSpecs[0]).findColumnIndex(this.nodeSettings.getInputColumnName());
        return new StreamableOperator(){

            public void runFinal(PortInput[] inputs, PortOutput[] outputs, ExecutionContext exec) throws Exception {
                DataRow row;
                RowInput input = (RowInput)inputs[0];
                RowOutput output = (RowOutput)outputs[0];
                while ((row = input.poll()) != null) {
                    exec.checkCanceled();
                    List extractedDates = Collections.emptyList();
                    DataCell cell = row.getCell(inputColumnIndex);
                    if (!cell.isMissing()) {
                        String text = DateExtractor2NodeModel.getText(cell);
                        extractedDates = DateParser.findDates((String)text);
                    }
                    List<DataRow> outRows = mappingStrategy.map(row, extractedDates, DateExtractor2NodeModel.this.nodeSettings, inputColumnIndex);
                    for (DataRow outRow : outRows) {
                        output.push(outRow);
                    }
                    exec.setProgress("Date Extracted for " + String.valueOf(row.getKey()));
                }
                input.close();
                output.close();
            }
        };
    }
}

