/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.date2;

import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.nodes.NodeSettings;
import ws.palladian.nodes.extraction.date2.MappingStrategy;

class DateExtractor2NodeSettings
implements NodeSettings {
    private static final String CFGKEY_COLUMN_NAME = "inputColumnName";
    private static final String CFGKEY_DROP_INPUT_COLUMN = "dropInputColumn";
    private static final String CFGKEY_OUPUT_COLUMN_NAME = "outputColumnName";
    private static final String CFGKEY_FORMAT_COLUMN = "appendFormatColumn";
    private static final String CFGKEY_MAPPING = "mappingType";
    private static final String CFGKEY_ROW_ID_COLUMN = "appendRowKey";
    private final SettingsModelString inputColumnName = new SettingsModelString("inputColumnName", null);
    private final SettingsModelBoolean dropInputColumn = new SettingsModelBoolean("dropInputColumn", false);
    private final SettingsModelString outputColumnName = new SettingsModelString("outputColumnName", "Extracted Date");
    private final SettingsModelBoolean appendFormat = new SettingsModelBoolean("appendFormatColumn", false);
    private final SettingsModelBoolean appendRowId = new SettingsModelBoolean("appendRowKey", false);
    private final SettingsModelString mapping;

    DateExtractor2NodeSettings() {
        this.mapping = new SettingsModelString(CFGKEY_MAPPING, MappingStrategy.ROWS.label);
    }

    @Override
    public void saveSettingsTo(NodeSettingsWO settings) {
        this.inputColumnName.saveSettingsTo(settings);
        this.dropInputColumn.saveSettingsTo(settings);
        this.outputColumnName.saveSettingsTo(settings);
        this.appendFormat.saveSettingsTo(settings);
        this.appendRowId.saveSettingsTo(settings);
        this.mapping.saveSettingsTo(settings);
    }

    @Override
    public void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnName.loadSettingsFrom(settings);
        this.dropInputColumn.loadSettingsFrom(settings);
        this.outputColumnName.loadSettingsFrom(settings);
        this.appendFormat.loadSettingsFrom(settings);
        this.appendRowId.loadSettingsFrom(settings);
        this.mapping.loadSettingsFrom(settings);
    }

    @Override
    public void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.inputColumnName.validateSettings(settings);
        this.dropInputColumn.validateSettings(settings);
        this.outputColumnName.validateSettings(settings);
        this.appendFormat.validateSettings(settings);
        this.appendRowId.validateSettings(settings);
        this.mapping.validateSettings(settings);
    }

    public SettingsModelString getSettingInputColumnName() {
        return this.inputColumnName;
    }

    public SettingsModelBoolean getSettingDropInputColumn() {
        return this.dropInputColumn;
    }

    public SettingsModelString getSettingOutputColumnName() {
        return this.outputColumnName;
    }

    public SettingsModelBoolean getSettingAppendFormat() {
        return this.appendFormat;
    }

    public SettingsModelBoolean getSettingAppendRowId() {
        return this.appendRowId;
    }

    public SettingsModelString getSettingMapping() {
        return this.mapping;
    }

    boolean isAppendFormat() {
        return this.getSettingAppendFormat().getBooleanValue();
    }

    boolean isAppendRowId() {
        return this.getSettingAppendRowId().getBooleanValue();
    }

    String getInputColumnName() {
        return this.getSettingInputColumnName().getStringValue();
    }

    void setInputColumnName(String columnName) {
        this.getSettingInputColumnName().setStringValue(columnName);
    }

    MappingStrategy getMappingStrategy() {
        return MappingStrategy.getByLabel(this.getSettingMapping().getStringValue());
    }

    boolean isDropInputColumn() {
        return this.getSettingDropInputColumn().getBooleanValue();
    }
}

