/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.date2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.base.data.filter.column.FilterColumnTable;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.time.localdatetime.LocalDateTimeCellFactory;
import ws.palladian.helper.date.ExtractedDate;
import ws.palladian.nodes.extraction.date2.DateExtractor2NodeModel;
import ws.palladian.nodes.extraction.date2.DateExtractor2NodeSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum MappingStrategy {
    ROWS("Rows"){

        @Override
        public List<DataRow> map(DataRow inRow, List<ExtractedDate> dates, DateExtractor2NodeSettings settings, int inColIdx) {
            long outRowIndex = 0L;
            ArrayList<DataRow> rows = new ArrayList<DataRow>();
            for (ExtractedDate date : dates) {
                List cells = inRow.stream().collect(Collectors.toList());
                if (settings.isDropInputColumn()) {
                    cells.remove(inColIdx);
                }
                cells.add(DateExtractor2NodeModel.createDateAndTimeCell(date));
                if (settings.isAppendFormat()) {
                    cells.add(new StringCell(date.getFormat()));
                }
                if (settings.isAppendRowId()) {
                    cells.add(new StringCell(inRow.getKey().getString()));
                }
                RowKey appendedRowKey = new RowKey(inRow.getKey().getString() + "_" + outRowIndex++);
                rows.add((DataRow)new DefaultRow(appendedRowKey, cells));
            }
            return rows;
        }

        @Override
        public DataTableSpec createSpec(DataTableSpec inSpec, DateExtractor2NodeSettings settings) {
            DataTableSpecCreator specCreator = new DataTableSpecCreator(inSpec);
            String columnName = settings.getSettingOutputColumnName().getStringValue();
            specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName, LocalDateTimeCellFactory.TYPE).createSpec()});
            if (settings.isAppendFormat()) {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName + ": Format", StringCell.TYPE).createSpec()});
            }
            if (settings.isAppendRowId()) {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName + ": Row ID", StringCell.TYPE).createSpec()});
            }
            DataTableSpec spec = specCreator.createSpec();
            if (settings.isDropInputColumn()) {
                int inCellIndex = inSpec.findColumnIndex(settings.getInputColumnName());
                spec = FilterColumnTable.createFilterTableSpec((DataTableSpec)spec, (boolean)false, (int[])new int[]{inCellIndex});
            }
            return spec;
        }
    }
    ,
    COLLECTION_CELL("Collection Cell"){

        @Override
        public List<DataRow> map(DataRow inRow, List<ExtractedDate> dates, DateExtractor2NodeSettings settings, int inColIdx) {
            List cells = inRow.stream().collect(Collectors.toList());
            if (settings.isDropInputColumn()) {
                cells.remove(inColIdx);
            }
            cells.add(CollectionCellFactory.createListCell((Collection)dates.stream().map(date -> DateExtractor2NodeModel.createDateAndTimeCell(date)).collect(Collectors.toList())));
            if (settings.isAppendFormat()) {
                cells.add(CollectionCellFactory.createListCell((Collection)dates.stream().map(date -> date.getFormat()).map(StringCell::new).collect(Collectors.toList())));
            }
            if (settings.isAppendRowId()) {
                cells.add(new StringCell(inRow.getKey().getString()));
            }
            return Collections.singletonList(new DefaultRow(inRow.getKey(), cells));
        }

        @Override
        public DataTableSpec createSpec(DataTableSpec inSpec, DateExtractor2NodeSettings settings) {
            DataTableSpecCreator specCreator = new DataTableSpecCreator(inSpec);
            String columnName = settings.getSettingOutputColumnName().getStringValue();
            specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName, ListCell.getCollectionType((DataType)LocalDateTimeCellFactory.TYPE)).createSpec()});
            if (settings.isAppendFormat()) {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName + ": Format", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec()});
            }
            if (settings.isAppendRowId()) {
                specCreator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(columnName + ": Row ID", StringCell.TYPE).createSpec()});
            }
            DataTableSpec spec = specCreator.createSpec();
            if (settings.isDropInputColumn()) {
                int inCellIndex = inSpec.findColumnIndex(settings.getInputColumnName());
                spec = FilterColumnTable.createFilterTableSpec((DataTableSpec)spec, (boolean)false, (int[])new int[]{inCellIndex});
            }
            return spec;
        }
    }
    ,
    FIRST_DATE_TIME_CELL("Date and Time Cell (first)"){

        @Override
        public List<DataRow> map(DataRow inRow, List<ExtractedDate> dates, DateExtractor2NodeSettings settings, int inColIdx) {
            List cells = inRow.stream().collect(Collectors.toList());
            if (settings.isDropInputColumn()) {
                cells.remove(inColIdx);
            }
            cells.add(DateExtractor2NodeModel.createDateAndTimeCell(dates.stream().findFirst().orElse(null)));
            if (settings.isAppendFormat()) {
                cells.add(PalladianKnimeHelper.createStringCell(dates.stream().map(date -> date.getFormat()).findFirst().orElse(null)));
            }
            if (settings.isAppendRowId()) {
                cells.add(new StringCell(inRow.getKey().getString()));
            }
            return Collections.singletonList(new DefaultRow(inRow.getKey(), cells));
        }

        @Override
        public DataTableSpec createSpec(DataTableSpec inSpec, DateExtractor2NodeSettings settings) {
            return ROWS.createSpec(inSpec, settings);
        }
    };

    final String label;

    private MappingStrategy(String label) {
        this.label = label;
    }

    static String[] getLabels() {
        return (String[])Arrays.stream(MappingStrategy.values()).map(m -> m.label).sorted().toArray(String[]::new);
    }

    static MappingStrategy getByLabel(String label) {
        if ("String Cell (first)".equals(label)) {
            return FIRST_DATE_TIME_CELL;
        }
        return Arrays.stream(MappingStrategy.values()).filter(m -> m.label.equals(label)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown label: " + label));
    }

    public abstract List<DataRow> map(DataRow var1, List<ExtractedDate> var2, DateExtractor2NodeSettings var3, int var4);

    public abstract DataTableSpec createSpec(DataTableSpec var1, DateExtractor2NodeSettings var2);
}

