/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.io.IOException;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataCellDataInput;
import org.knime.core.data.DataCellDataOutput;
import org.knime.core.data.DataCellSerializer;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;

public class GeoCoordinateCell
extends DataCell
implements GeoCoordinateValue,
StringValue {
    private static final long serialVersionUID = 1L;
    public static final DataType TYPE = DataType.getType(GeoCoordinateCell.class);
    private final GeoCoordinate coordinate;

    public GeoCoordinateCell(double latitude, double longitude) {
        this.coordinate = GeoCoordinate.from((double)latitude, (double)longitude);
    }

    public GeoCoordinateCell(GeoCoordinate coordinate) {
        if (coordinate == null) {
            throw new NullPointerException("Coordinate must not be null");
        }
        this.coordinate = coordinate;
    }

    public static DataCell create(GeoCoordinate coordinateOrNull) {
        return coordinateOrNull != null ? new GeoCoordinateCell(coordinateOrNull) : DataType.getMissingCell();
    }

    public String getStringValue() {
        return String.format("%s %s", this.coordinate.getLatitude(), this.coordinate.getLongitude());
    }

    public double getLongitude() {
        return this.coordinate.getLongitude();
    }

    public double getLatitude() {
        return this.coordinate.getLatitude();
    }

    public double distance(GeoCoordinate other) {
        return this.coordinate.distance(other);
    }

    public double[] getBoundingBox(double distance) {
        return this.coordinate.getBoundingBox(distance);
    }

    public String toDmsString() {
        return this.coordinate.toDmsString();
    }

    public GeoCoordinate getCoordinate(double distance, double bearing) {
        return this.coordinate.getCoordinate(distance, bearing);
    }

    public String toString() {
        return this.getStringValue();
    }

    protected boolean equalsDataCell(DataCell dc) {
        if (dc != null && dc.getType().isCompatible(GeoCoordinateValue.class)) {
            GeoCoordinateValue geoValue = (GeoCoordinateValue)dc;
            if (geoValue.getLatitude() != this.getLatitude()) {
                return false;
            }
            return geoValue.getLongitude() == this.getLongitude();
        }
        return false;
    }

    public int hashCode() {
        return this.coordinate.hashCode();
    }

    public static final class GeoCoordinateSerializer
    implements DataCellSerializer<GeoCoordinateCell> {
        public void serialize(GeoCoordinateCell cell, DataCellDataOutput output) throws IOException {
            output.writeDouble(cell.getLatitude());
            output.writeDouble(cell.getLongitude());
        }

        public GeoCoordinateCell deserialize(DataCellDataInput input) throws IOException {
            double lat = input.readDouble();
            double lng = input.readDouble();
            return new GeoCoordinateCell(lat, lng);
        }
    }
}

