/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.extraction.location.geocoder.Geocoder;
import ws.palladian.extraction.location.geocoder.GeocoderException;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.CachedGeocoder;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.GeocoderNodeDialog;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

public abstract class GeocoderNodeModel
extends SimpleStreamableFunctionNodeModel {
    static final String CFGKEY_INPUT_COLUMN_NAME = "settingInputColumn";
    private final SettingsModelString settingInputColumn = GeocoderNodeDialog.createSettingsInputColumn();

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        DataColumnSpec coordinateSpec = new DataColumnSpecCreator("coordinate", GeoCoordinateCell.TYPE).createSpec();
        final int inputIdx = spec.findColumnIndex(this.settingInputColumn.getStringValue());
        if (inputIdx < 0) {
            throw new IllegalStateException("Column index was " + inputIdx);
        }
        LazyInitializer<Geocoder> geocoder = new LazyInitializer<Geocoder>(){

            protected Geocoder initialize() throws ConcurrentException {
                return new CachedGeocoder(GeocoderNodeModel.this.createGeocoder());
            }
        };
        SingleCellFactory factory = new SingleCellFactory(coordinateSpec, (LazyInitializer)geocoder){
            private final /* synthetic */ LazyInitializer val$geocoder;
            {
                this.val$geocoder = lazyInitializer;
                super($anonymous0);
            }

            public DataCell getCell(DataRow row) {
                GeoCoordinate coordinate;
                DataCell addressCell = row.getCell(inputIdx);
                if (addressCell.isMissing()) {
                    return DataType.getMissingCell();
                }
                String text = ((StringValue)addressCell).getStringValue();
                if (text.isEmpty()) {
                    return DataType.getMissingCell();
                }
                try {
                    coordinate = ((Geocoder)this.val$geocoder.get()).geoCode(text);
                }
                catch (GeocoderException e) {
                    throw new IllegalStateException(e);
                }
                catch (ConcurrentException e) {
                    throw new IllegalStateException(e);
                }
                if (coordinate == null) {
                    return DataType.getMissingCell();
                }
                return new GeoCoordinateCell(coordinate);
            }
        };
        factory.setParallelProcessing(true, 10, 50);
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)factory);
        return rearranger;
    }

    protected abstract Geocoder createGeocoder();

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec coordinateSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingInputColumn.getStringValue(), StringValue.class);
        if (coordinateSpec == null) {
            coordinateSpec = PalladianKnimeHelper.guessColumn(inSpec, StringValue.class);
            String columnName = coordinateSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingInputColumn.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingInputColumn.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingInputColumn.validateSettings(settings);
    }
}

