/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.RowKey;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelDouble;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import ws.palladian.extraction.location.Location;
import ws.palladian.extraction.location.LocationSource;
import ws.palladian.helper.geo.GeoCoordinate;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.extraction.location.GeoCoordinateCell;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.ReverseLocationLookupNodeDialog;
import ws.palladian.nodes.extraction.location.source.LocationSourceRegistry;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

@Deprecated
public class ReverseLocationLookupNodeModel
extends NodeModel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ReverseLocationLookupNodeModel.class);
    static final String CFGKEY_COORDINATE_COLUMN = "coordinateInputColumn";
    static final String CFGKEY_RADIUS = "searchRadius";
    static final int DEFAULT_RADIUS = 1;
    static final String CFGKEY_NUM_RESULTS = "numResults";
    static final int DEFAULT_NUM_RESULTS = 10;
    private final SettingsModelString settingCoordinateInputColumn = ReverseLocationLookupNodeDialog.createSettingsInputColumn();
    private final SettingsModelDouble settingSearchRadius = ReverseLocationLookupNodeDialog.createSettingsRadius();
    private final SettingsModelInteger settingNumResults = ReverseLocationLookupNodeDialog.createSettingsNumResults();

    protected ReverseLocationLookupNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        BufferedDataTable inTable = inData[0];
        DataTableSpec inSpec = inTable.getSpec();
        DataTableSpec outSpec = this.createOutputSpec(inSpec);
        BufferedDataContainer outTable = exec.createDataContainer(outSpec);
        String columnName = this.settingCoordinateInputColumn.getStringValue();
        int inputIdx = inSpec.findColumnIndex(columnName);
        if (inputIdx < 0) {
            throw new IllegalStateException("Invalid input index: " + inputIdx);
        }
        double radius = this.settingSearchRadius.getDoubleValue();
        int numLocations = this.settingNumResults.getIntValue();
        LocationSource source = LocationSourceRegistry.createCombinedLocationSource();
        long outRowIndex = 0L;
        long inRowIndex = 0L;
        long inRowCount = inTable.size();
        for (DataRow inRow : inTable) {
            DataCell cell = inRow.getCell(inputIdx);
            if (cell.isMissing()) {
                LOGGER.debug((Object)("Skip missing value in row " + inRowIndex));
                continue;
            }
            GeoCoordinateValue coordinate = (GeoCoordinateValue)cell;
            LOGGER.debug((Object)("Coordinate = " + String.valueOf(coordinate)));
            List locations = source.getLocations((GeoCoordinate)coordinate, radius);
            int currentAddedLocations = 0;
            for (Location location : locations) {
                LOGGER.debug((Object)("   Location = " + String.valueOf(location)));
                RowKey rowKey = RowKey.createRowKey((long)outRowIndex++);
                StringCell nameCell = new StringCell(location.getPrimaryName());
                StringCell typeCell = new StringCell(location.getType().toString());
                GeoCoordinate locationCoordinate = location.getCoordinate();
                DataCell coordinateCell = locationCoordinate != null ? new GeoCoordinateCell(locationCoordinate) : DataType.getMissingCell();
                Long population = location.getPopulation();
                DataCell populationCell = population != null ? new LongCell(population.longValue()) : DataType.getMissingCell();
                DataCell distanceCell = locationCoordinate != null ? new DoubleCell(locationCoordinate.distance((GeoCoordinate)coordinate)) : DataType.getMissingCell();
                AppendedColumnRow appendedRow = new AppendedColumnRow(rowKey, inRow, new DataCell[]{nameCell});
                appendedRow = new AppendedColumnRow((DataRow)appendedRow, new DataCell[]{typeCell});
                appendedRow = new AppendedColumnRow((DataRow)appendedRow, new DataCell[]{coordinateCell});
                appendedRow = new AppendedColumnRow((DataRow)appendedRow, new DataCell[]{populationCell});
                appendedRow = new AppendedColumnRow((DataRow)appendedRow, new DataCell[]{distanceCell});
                outTable.addRowToTable((DataRow)appendedRow);
                exec.checkCanceled();
                if (++currentAddedLocations >= numLocations) break;
            }
            exec.setProgress((double)(++inRowIndex) / (double)inRowCount, "Processing row " + inRowIndex);
        }
        outTable.close();
        return new BufferedDataTable[]{outTable.getTable()};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inSpec) {
        DataColumnSpec[] appendedSpec = new DataColumnSpec[]{new DataColumnSpecCreator("Location Name", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Type", StringCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Coordinates", GeoCoordinateCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Population", LongCell.TYPE).createSpec(), new DataColumnSpecCreator("Location Distance", DoubleCell.TYPE).createSpec()};
        return new DataTableSpec(inSpec, new DataTableSpec(appendedSpec));
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        DataColumnSpec columnSpec = PalladianKnimeHelper.getColumn(inSpec, this.settingCoordinateInputColumn.getStringValue(), GeoCoordinateValue.class);
        if (columnSpec == null) {
            columnSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            String columnName = columnSpec.getName();
            this.setWarningMessage("Guessing input column: " + columnName);
            this.settingCoordinateInputColumn.setStringValue(columnName);
        }
        return new DataTableSpec[]{this.createOutputSpec(inSpec)};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.settingCoordinateInputColumn.saveSettingsTo(settings);
        this.settingSearchRadius.saveSettingsTo(settings);
        this.settingNumResults.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingCoordinateInputColumn.loadSettingsFrom(settings);
        this.settingSearchRadius.loadSettingsFrom(settings);
        this.settingNumResults.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.settingCoordinateInputColumn.validateSettings(settings);
        this.settingSearchRadius.validateSettings(settings);
        this.settingNumResults.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

