/*
 * Decompiled with CFR 0.152.
 */
package ws.palladian.nodes.extraction.location.coordinate.formatter;

import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.streamable.simple.SimpleStreamableFunctionNodeModel;
import ws.palladian.nodes.PalladianPluginActivator;
import ws.palladian.nodes.StringUtils;
import ws.palladian.nodes.extraction.location.GeoCoordinateValue;
import ws.palladian.nodes.extraction.location.coordinate.formatter.CoordinateFormatterSettings;
import ws.palladian.nodes.helper.PalladianKnimeHelper;

class CoordinateFormatterNodeModel
extends SimpleStreamableFunctionNodeModel {
    private final CoordinateFormatterSettings nodeSettings = new CoordinateFormatterSettings();

    CoordinateFormatterNodeModel() {
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        PalladianPluginActivator.checkLicense();
        return super.execute(inData, exec);
    }

    protected ColumnRearranger createColumnRearranger(DataTableSpec spec) throws InvalidSettingsException {
        final int inColIdx = spec.findColumnIndex(this.nodeSettings.inputColumn.getStringValue());
        Object appendedColumnName = this.nodeSettings.formattedColumn.getStringValue();
        if (StringUtils.nullOrEmpty((String)appendedColumnName)) {
            appendedColumnName = this.nodeSettings.inputColumn.getStringValue() + " (DMS)";
        }
        DataColumnSpec colSpec = new DataColumnSpecCreator((String)appendedColumnName, StringCell.TYPE).createSpec();
        SingleCellFactory cellFactory = new SingleCellFactory(colSpec){

            public DataCell getCell(DataRow row) {
                DataCell cell = row.getCell(inColIdx);
                if (cell.isMissing()) {
                    return DataType.getMissingCell();
                }
                GeoCoordinateValue coordinate = (GeoCoordinateValue)cell;
                String dms = coordinate.toDmsString();
                return new StringCell(dms);
            }
        };
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)cellFactory);
        if (this.nodeSettings.dropInputColumn.getBooleanValue()) {
            rearranger.remove(new int[]{inColIdx});
        }
        return rearranger;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec inSpec = inSpecs[0];
        if (StringUtils.notNullOrEmpty(this.nodeSettings.inputColumn.getStringValue())) {
            PalladianKnimeHelper.checkHasColumn(inSpec, this.nodeSettings.inputColumn.getStringValue(), GeoCoordinateValue.class);
        } else {
            DataColumnSpec urlColSpec = PalladianKnimeHelper.guessColumn(inSpec, GeoCoordinateValue.class);
            String columnName = urlColSpec.getName();
            this.setWarningMessage("Guessing coordinate input column: " + columnName);
            this.nodeSettings.inputColumn.setStringValue(columnName);
        }
        return super.configure(inSpecs);
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.nodeSettings.saveSettingsTo(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.validateSettings(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.nodeSettings.loadValidatedSettingsFrom(settings);
    }
}

